/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.Config;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.mixin_interfaces.IGenerallySearchableNavigation;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.packet.SwitchDataUpdatePacket;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Navigation;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CarriageContraptionEntity.class}, remap=false)
public abstract class MixinCarriageContraptionEntity
extends OrientedContraptionEntity {
    @Shadow
    private Carriage carriage;
    private boolean snr$fakePlayer = false;
    boolean switchMessage = false;

    private MixinCarriageContraptionEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"control"}, at={@At(value="HEAD")})
    private void recordFakePlayer(BlockPos controlsLocalPos, Collection<Integer> heldControls, Player player, CallbackInfoReturnable<Boolean> cir) {
        if (player.m_36316_() == ConductorEntity.FAKE_PLAYER_PROFILE) {
            this.snr$fakePlayer = true;
        }
    }

    @Redirect(method={"control"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;closerThan(Lnet/minecraft/core/Position;D)Z", remap=true))
    private boolean snr$closerThan(Vec3 instance, Position pos, double distance) {
        if (this.snr$fakePlayer) {
            this.snr$fakePlayer = false;
            return true;
        }
        return instance.m_82509_(pos, distance);
    }

    @Inject(method={"control"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;maxSpeed()F")})
    private void showSwitchOverlay(BlockPos controlsLocalPos, Collection<Integer> heldControls, Player player, CallbackInfoReturnable<Boolean> cir) {
        Optional targetState;
        Navigation nav = this.carriage.train.navigation;
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)this.contraption.getBlocks().get(controlsLocalPos);
        Direction initialOrientation = this.getInitialOrientation().m_122428_();
        boolean inverted = false;
        if (info != null && info.f_74676_.m_61138_((Property)ControlsBlock.f_54117_)) {
            inverted = !((Direction)info.f_74676_.m_61143_((Property)ControlsBlock.f_54117_)).equals((Object)initialOrientation);
        }
        int targetSpeed = 0;
        if (heldControls.contains(0)) {
            ++targetSpeed;
        }
        if (heldControls.contains(1)) {
            --targetSpeed;
        }
        if (inverted) {
            targetSpeed *= -1;
        }
        boolean spaceDown = heldControls.contains(4);
        double directedSpeed = targetSpeed != 0 ? (double)targetSpeed : this.carriage.train.speed;
        Railways.temporarilySkipSwitches = true;
        boolean forward = !this.carriage.train.doubleEnded || (directedSpeed != 0.0 ? directedSpeed > 0.0 : !inverted);
        Pair<TrackSwitch, Pair<Boolean, Optional<TrackSwitchBlock.SwitchState>>> lookAheadData = ((IGenerallySearchableNavigation)nav).findNearestApproachableSwitch(forward);
        Railways.temporarilySkipSwitches = false;
        TrackSwitch lookAhead = lookAheadData == null ? null : (TrackSwitch)((Object)lookAheadData.getFirst());
        boolean headOn = lookAheadData != null && (Boolean)((Pair)lookAheadData.getSecond()).getFirst() != false;
        Optional optional = targetState = lookAheadData == null ? Optional.empty() : (Optional)((Pair)lookAheadData.getSecond()).getSecond();
        if (lookAhead != null) {
            if (((Boolean)Config.FLIP_DISTANT_SWITCHES.get()).booleanValue() && spaceDown && lookAhead.isAutomatic() && !lookAhead.isLocked() && !this.carriage.train.navigation.isActive()) {
                if (headOn) {
                    lookAhead.trySetSwitchState(TrackSwitchBlock.SwitchState.fromSteerDirection(this.carriage.train.manualSteer, forward));
                } else {
                    targetState.ifPresent(lookAhead::trySetSwitchState);
                }
            }
            boolean wrong = headOn ? TrackSwitchBlock.SwitchState.fromSteerDirection(this.carriage.train.manualSteer, forward) != lookAhead.getSwitchState() : targetState.isPresent() && lookAhead.getSwitchState() != targetState.get();
            this.displayApproachSwitchMessage(player, lookAhead, wrong);
        } else {
            this.cleanUpApproachSwitchMessage(player);
        }
    }

    private void displayApproachSwitchMessage(Player player, TrackSwitch sw, boolean isWrong) {
        this.sendSwitchInfo(player, sw.getSwitchState(), sw.isAutomatic(), isWrong, sw.isLocked());
        this.switchMessage = true;
    }

    private void cleanUpApproachSwitchMessage(Player player) {
        if (!this.switchMessage) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            CRPackets.PACKETS.sendTo(sp, (S2CPacket)SwitchDataUpdatePacket.clear());
        }
        this.switchMessage = false;
    }

    private void sendSwitchInfo(Player player, TrackSwitchBlock.SwitchState state, boolean automatic, boolean isWrong, boolean isLocked) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            CRPackets.PACKETS.sendTo(sp, (S2CPacket)new SwitchDataUpdatePacket(state, automatic, isWrong, isLocked));
        }
    }

    @Inject(method={"updateTrackGraph"}, at={@At(value="FIELD", target="Lcom/simibubi/create/content/trains/entity/Train;graph:Lcom/simibubi/create/content/trains/graph/TrackGraph;", opcode=3, ordinal=0)}, cancellable=true)
    private void cancelDerailing(CallbackInfo ci) {
        if (((Boolean)Config.SKIP_CLIENT_DERAILING.get()).booleanValue()) {
            ci.cancel();
        }
    }
}

