/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.events;

import com.railwayteam.railways.Config;
import com.railwayteam.railways.compat.journeymap.DummyRailwayMarkerHandler;
import com.railwayteam.railways.content.conductor.ConductorPossessionController;
import com.railwayteam.railways.content.custom_bogeys.selection_menu.BogeyCategoryHandlerClient;
import com.railwayteam.railways.content.custom_tracks.phantom.PhantomSpriteManager;
import com.railwayteam.railways.registry.CRExtraRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;

public class ClientEvents {
    public static void onClientTickStart(Minecraft mc) {
        long ticks;
        PhantomSpriteManager.tick(mc);
        if (DummyRailwayMarkerHandler.getInstance() == null) {
            return;
        }
        ClientLevel level = mc.f_91073_;
        long l = ticks = level == null ? 1L : level.m_46467_();
        if (ticks % (long)((Integer)Config.JOURNEYMAP_REMOVE_OBSOLETE_TICKS.get()).intValue() == 0L) {
            DummyRailwayMarkerHandler.getInstance().removeObsolete();
            DummyRailwayMarkerHandler.getInstance().reloadMarkers();
        }
        if (ticks % (long)((Integer)Config.JOURNEYMAP_UPDATE_TICKS.get()).intValue() == 0L) {
            DummyRailwayMarkerHandler.getInstance().runUpdates();
        }
        if (ClientEvents.isGameActive()) {
            BogeyCategoryHandlerClient.clientTick();
            ConductorPossessionController.onClientTick(mc, true);
        }
    }

    public static void onClientTickEnd(Minecraft mc) {
        if (ClientEvents.isGameActive()) {
            ConductorPossessionController.onClientTick(mc, false);
        }
    }

    public static void onClientWorldLoad(Level level) {
        DummyRailwayMarkerHandler.getInstance().onJoinWorld();
        PhantomSpriteManager.firstRun = true;
        CRExtraRegistration.register();
    }

    protected static boolean isGameActive() {
        return Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null;
    }

    public static void onKeyInput(int key, boolean pressed) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        BogeyCategoryHandlerClient.onKeyInput(key, pressed);
    }
}

