/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways;

import com.mojang.brigadier.CommandDispatcher;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.compat.journeymap.RailwayMapPlugin;
import com.railwayteam.railways.content.conductor.ConductorCapModel;
import com.railwayteam.railways.content.conductor.ConductorEntityModel;
import com.railwayteam.railways.forge.RailwaysClientImpl;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRBogeyStyles;
import com.railwayteam.railways.registry.CRCommandsClient;
import com.railwayteam.railways.registry.CRDevCaps;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.registry.CRPonderIndex;
import com.railwayteam.railways.util.CustomTrackOverlayRendering;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.commands.SharedSuggestionProvider;

public class RailwaysClient {
    public static void init() {
        RailwaysClient.registerModelLayer(ConductorEntityModel.LAYER_LOCATION, ConductorEntityModel::createBodyLayer);
        RailwaysClient.registerModelLayer(ConductorCapModel.LAYER_LOCATION, ConductorCapModel::createBodyLayer);
        RailwaysClient.registerBuiltinPack("legacy_semaphore", "Steam 'n Rails Legacy Semaphores");
        RailwaysClient.registerBuiltinPack("green_signals", "Steam 'n Rails Green Signals");
        RailwaysClient.registerClientCommands(CRCommandsClient::register);
        CRPackets.PACKETS.registerS2CListener();
        CRPonderIndex.register();
        CRBlockPartials.init();
        CustomTrackOverlayRendering.register(CREdgePointTypes.COUPLER, CRBlockPartials.COUPLER_BOTH);
        CustomTrackOverlayRendering.register(CREdgePointTypes.SWITCH, CRBlockPartials.SWITCH_RIGHT_TURN);
        Mods.JOURNEYMAP.executeIfInstalled(() -> RailwayMapPlugin::load);
        CRDevCaps.register();
        CRBogeyStyles.registerClient();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerClientCommands(Consumer<CommandDispatcher<SharedSuggestionProvider>> consumer) {
        RailwaysClientImpl.registerClientCommands(consumer);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerModelLayer(ModelLayerLocation layer, Supplier<LayerDefinition> definition) {
        void var1_1;
        RailwaysClientImpl.registerModelLayer(layer, (Supplier<LayerDefinition>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBuiltinPack(String id, String name) {
        void var1_1;
        RailwaysClientImpl.registerBuiltinPack(id, (String)var1_1);
    }
}

