/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.category;

import com.buuz135.industrial.plugin.jei.IndustrialRecipeTypes;
import javax.annotation.Nullable;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public class BioReactorRecipeCategory
implements IRecipeCategory<ReactorRecipeWrapper> {
    private IGuiHelper guiHelper;
    private IDrawable tankOverlay;
    private Component title;

    public BioReactorRecipeCategory(IGuiHelper guiHelper, String title) {
        this.guiHelper = guiHelper;
        this.tankOverlay = guiHelper.createDrawable(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 1, 207, 12, 48);
        this.title = new TranslatableComponent(title);
    }

    public ResourceLocation getUid() {
        return IndustrialRecipeTypes.BIOREACTOR.getUid();
    }

    public Class<? extends ReactorRecipeWrapper> getRecipeClass() {
        return IndustrialRecipeTypes.BIOREACTOR.getRecipeClass();
    }

    public RecipeType<ReactorRecipeWrapper> getRecipeType() {
        return IndustrialRecipeTypes.BIOREACTOR;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 0, 27, 70, 50);
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ReactorRecipeWrapper recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 17).addIngredients(Ingredient.m_204132_(recipe.stack));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 57, 1).setFluidRenderer(1000, false, 12, 48).setOverlay(this.tankOverlay, 0, 0).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getFluid());
    }

    public static class ReactorRecipeWrapper {
        private TagKey<Item> stack;
        private FluidStack fluid;

        public ReactorRecipeWrapper(TagKey<Item> stack, FluidStack fluid) {
            this.stack = stack;
            this.fluid = fluid;
        }

        public TagKey<Item> getStack() {
            return this.stack;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }
    }
}

