/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.fluid;

import com.buuz135.industrial.fluid.OreFluidInstance;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.hrznstudio.titanium.util.TagUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class OreTitaniumFluidAttributes
extends FluidAttributes {
    public static final String NBT_TAG = "Tag";

    public OreTitaniumFluidAttributes(FluidAttributes.Builder builder, Fluid fluid) {
        super(builder, fluid);
    }

    public int getColor(FluidStack stack) {
        String tag;
        List items;
        if (Minecraft.m_91087_().f_91073_ != null && stack.hasTag() && stack.getTag().m_128441_(NBT_TAG) && (items = TagUtil.getAllEntries((IForgeRegistry)ForgeRegistries.ITEMS, (TagKey)TagUtil.getItemTag((ResourceLocation)new ResourceLocation((tag = stack.getTag().m_128461_(NBT_TAG)).replace("forge:raw_materials/", "forge:dusts/")))).stream().toList()).size() > 0) {
            return ItemStackUtils.getColor(new ItemStack((ItemLike)items.get(0)));
        }
        return super.getColor(stack);
    }

    public String getTranslationKey(FluidStack stack) {
        String tag;
        List items;
        Object extra = "";
        if (stack.hasTag() && stack.getTag().m_128441_(NBT_TAG) && (items = TagUtil.getAllEntries((IForgeRegistry)ForgeRegistries.ITEMS, (TagKey)TagUtil.getItemTag((ResourceLocation)new ResourceLocation((tag = stack.getTag().m_128461_(NBT_TAG)).replace("forge:raw_materials/", "forge:dusts/")))).stream().toList()).size() > 0) {
            extra = " (" + new TranslatableComponent(((Item)items.get(0)).m_5524_()).getString() + ")";
        }
        return new TranslatableComponent(super.getTranslationKey(stack)).getString() + (String)extra;
    }

    public Component getDisplayName(FluidStack stack) {
        String tag;
        List items;
        Object extra = "";
        if (stack.hasTag() && stack.getTag().m_128441_(NBT_TAG) && (items = TagUtil.getAllEntries((IForgeRegistry)ForgeRegistries.ITEMS, (TagKey)TagUtil.getItemTag((ResourceLocation)new ResourceLocation((tag = stack.getTag().m_128461_(NBT_TAG)).replace("forge:raw_materials/", "forge:dusts/")))).stream().toList()).size() > 0) {
            extra = " (" + new TranslatableComponent(((Item)items.get(0)).m_5524_()).getString() + ")";
        }
        return new TextComponent(super.getDisplayName(stack).getString() + (String)extra);
    }

    public static FluidStack getFluidWithTag(OreFluidInstance fluidInstance, int amount, ResourceLocation itemITag) {
        FluidStack stack = new FluidStack(fluidInstance.getSourceFluid(), amount);
        stack.getOrCreateTag().m_128359_(NBT_TAG, itemITag.toString());
        return stack;
    }

    public static String getFluidTag(FluidStack stack) {
        return stack.getOrCreateTag().m_128461_(NBT_TAG);
    }

    public static boolean isValid(ResourceLocation resourceLocation) {
        TagKey key = TagUtil.getItemTag((ResourceLocation)new ResourceLocation("forge:dusts/" + resourceLocation.toString().replace("forge:raw_materials/", "")));
        return ForgeRegistries.ITEMS.tags().isKnownTagName(key) && !TagUtil.getAllEntries((IForgeRegistry)ForgeRegistries.ITEMS, (TagKey)key).isEmpty();
    }

    public static ItemStack getOutputDust(FluidStack stack) {
        String tag = OreTitaniumFluidAttributes.getFluidTag(stack);
        return TagUtil.getItemWithPreference((TagKey)TagUtil.getItemTag((ResourceLocation)new ResourceLocation(tag.replace("forge:raw_materials/", "forge:dusts/"))));
    }

    public ItemStack getBucket(FluidStack stack) {
        ItemStack bucket = super.getBucket(stack);
        if (stack.hasTag() && stack.getTag().m_128441_(NBT_TAG)) {
            String tag = stack.getTag().m_128461_(NBT_TAG);
            bucket.m_41784_().m_128359_(NBT_TAG, tag);
        }
        return bucket;
    }
}

