/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import com.buuz135.industrial.block.tile.IndustrialMachineTile;
import com.buuz135.industrial.item.addon.ProcessingAddonItem;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.redstone.RedstoneAction;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public abstract class IndustrialProcessingTile<T extends IndustrialProcessingTile<T>>
extends IndustrialMachineTile<T> {
    @Save
    private ProgressBarComponent<T> progressBar;

    public IndustrialProcessingTile(Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> basicTileBlock, final int x, final int y, BlockPos blockPos, BlockState blockState) {
        super(basicTileBlock, blockPos, blockState);
        this.progressBar = new ProgressBarComponent<T>(x, y, this.getMaxProgress()){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon(x, y, IndustrialProcessingTile.this.progressBar){

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> tooltip = new ArrayList<Component>();
                        tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + new TranslatableComponent("tooltip.titanium.progressbar.progress").getString() + ChatFormatting.WHITE + new DecimalFormat().format(IndustrialProcessingTile.this.progressBar.getProgress()) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + new DecimalFormat().format(IndustrialProcessingTile.this.progressBar.getMaxProgress())));
                        int progress = IndustrialProcessingTile.this.progressBar.getMaxProgress() - IndustrialProcessingTile.this.progressBar.getProgress();
                        if (!IndustrialProcessingTile.this.progressBar.getIncreaseType()) {
                            progress = IndustrialProcessingTile.this.progressBar.getMaxProgress() - progress;
                        }
                        tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + "ETA: " + ChatFormatting.WHITE + new DecimalFormat().format(Math.ceil((double)(progress * IndustrialProcessingTile.this.progressBar.getTickingTime()) / 20.0 / (double)IndustrialProcessingTile.this.progressBar.getProgressIncrease())) + ChatFormatting.DARK_AQUA + "s"));
                        tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + new TranslatableComponent("tooltip.industrialforegoing.usage").getString() + ChatFormatting.WHITE + IndustrialProcessingTile.this.getTickPower() + ChatFormatting.DARK_AQUA + " FE" + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + ChatFormatting.DARK_AQUA + "t"));
                        return tooltip;
                    }
                });
            }
        }.setComponentHarness((IComponentHarness)((IndustrialProcessingTile)this.getSelf())).setBarDirection(this.getBarDirection()).setCanReset(tileEntity -> true).setOnStart(() -> {
            int maxProgress = (int)Math.floor((float)this.getMaxProgress() * (this.hasAugmentInstalled(AugmentTypes.EFFICIENCY) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.EFFICIENCY).get(0)), (IAugmentType)AugmentTypes.EFFICIENCY) : 1.0f));
            this.progressBar.setMaxProgress(maxProgress);
        }).setCanIncrease(tileEntity -> this.getEnergyStorage().getEnergyStored() >= this.getTickPower() && this.canIncrease() && ((RedstoneAction)this.getRedstoneManager().getAction()).canRun(tileEntity.getEnvironmentValue(false, null)) && this.getRedstoneManager().shouldWork()).setOnTickWork(() -> {
            this.getEnergyStorage().extractEnergy(this.getTickPower(), false);
            this.progressBar.setProgressIncrease(this.hasAugmentInstalled(AugmentTypes.SPEED) ? (int)AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.SPEED).get(0)), (IAugmentType)AugmentTypes.SPEED) : 1);
        }).setOnFinishWork(() -> {
            int operations = (int)(this.hasAugmentInstalled(ProcessingAddonItem.PROCESSING) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(ProcessingAddonItem.PROCESSING).get(0)), (IAugmentType)ProcessingAddonItem.PROCESSING) : 1.0f);
            for (int i = 0; i < operations; ++i) {
                if (!this.canIncrease()) continue;
                this.onFinish().run();
            }
            this.getRedstoneManager().finish();
        });
        this.addProgressBar(this.progressBar);
    }

    public ProgressBarComponent<T> getProgressBar() {
        return this.progressBar;
    }

    public InteractionResult onActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        this.openGui(playerIn);
        return InteractionResult.PASS;
    }

    public int getMaxProgress() {
        return 100;
    }

    public abstract boolean canIncrease();

    public abstract Runnable onFinish();

    protected abstract int getTickPower();

    public ProgressBarComponent.BarDirection getBarDirection() {
        return ProgressBarComponent.BarDirection.ARROW_RIGHT;
    }
}

