/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.FermentationStationConfig;
import com.buuz135.industrial.fluid.OreTitaniumFluidAttributes;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.proxy.client.IndustrialAssetProvider;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FermentationStationTile
extends IndustrialProcessingTile<FermentationStationTile> {
    @Save
    private SidedFluidTankComponent<FermentationStationTile> input = (SidedFluidTankComponent)new SidedFluidTankComponent<FermentationStationTile>("input", 4000, 50, 20, 0){

        protected void onContentsChanged() {
            FermentationStationTile.this.syncObject(FermentationStationTile.this.input);
        }

        public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
            return Collections.emptyList();
        }
    }.setColor(DyeColor.BROWN).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> !this.isSealed && fluidStack.getFluid().m_6212_(ModuleCore.RAW_ORE_MEAT.getSourceFluid()));
    @Save
    private SidedFluidTankComponent<FermentationStationTile> output;
    @Save
    private SidedFluidTankComponent<FermentationStationTile> catalyst;
    @Save
    private int production;
    @Save
    private int seal;
    @Save
    private boolean isSealed;

    public FermentationStationTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.FERMENTATION_STATION, 90, 40, blockPos, blockState);
        this.addTank(this.input);
        this.output = (SidedFluidTankComponent)new SidedFluidTankComponent<FermentationStationTile>("output", 32000, 130, 20, 1){

            protected void onContentsChanged() {
                FermentationStationTile.this.syncObject(FermentationStationTile.this.output);
            }

            public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
                return Collections.emptyList();
            }
        }.setColor(DyeColor.ORANGE).setTankAction(FluidTankComponent.Action.DRAIN);
        this.addTank(this.output);
        this.catalyst = (SidedFluidTankComponent)new SidedFluidTankComponent("catalyst", 2000, 90, 60, 2).setColor(DyeColor.LIME).setTankType(FluidTankComponent.Type.SMALL).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().m_6212_((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get()) || fluidStack.getFluid().m_6212_((Fluid)ModuleCore.ETHER.getSourceFluid().get()));
        this.addTank(this.catalyst);
        this.production = 0;
        this.seal = 0;
        this.isSealed = false;
        this.addButton(new ButtonComponent(75, 22, 14, 14){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new StateButtonAddon(this, (StateButtonInfo[])Arrays.stream(SealType.values()).map(sealType -> sealType.info).toArray(StateButtonInfo[]::new)){

                    public int getState() {
                        return FermentationStationTile.this.seal;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            ++this.seal;
            this.seal %= SealType.values().length;
            this.syncObject(this.seal);
        }));
        this.addButton(new ButtonComponent(110, 22, 14, 14){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new StateButtonAddon(this, (StateButtonInfo[])Arrays.stream(ProductionType.values()).map(sealType -> sealType.info).toArray(StateButtonInfo[]::new)){

                    public int getState() {
                        return FermentationStationTile.this.production;
                    }

                    @OnlyIn(value=Dist.CLIENT)
                    public List<Component> getTooltipLines() {
                        ProductionType type = ProductionType.values()[FermentationStationTile.this.production];
                        ArrayList<Component> list = new ArrayList<Component>(super.getTooltipLines());
                        list.add((Component)new TranslatableComponent("text.industrialforegoing.tooltip.fermentation_station.time").m_130946_(type.getTicks() / 20 + "s"));
                        list.add((Component)new TranslatableComponent("text.industrialforegoing.tooltip.fermentation_station.catalyst").m_130946_(type.getNeededFluid().isEmpty() ? "None" : new TranslatableComponent(type.getNeededFluid().getTranslationKey()).getString()));
                        return list;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            ++this.production;
            this.production %= ProductionType.values().length;
            this.getProgressBar().setMaxProgress(ProductionType.values()[this.production].getTicks());
            this.syncObject(this.production);
        }));
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, FermentationStationTile blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        if (this.seal < SealType.values().length) {
            boolean sealValue = SealType.values()[this.seal].canSeal.test(this.input);
            if (sealValue != this.isSealed) {
                this.markForUpdate();
            }
            this.isSealed = sealValue;
        }
    }

    @Override
    public boolean canIncrease() {
        ProductionType productionType = ProductionType.values()[this.production];
        int multipliedAmount = productionType.amount * this.input.getFluidAmount();
        return this.isSealed && this.output.getFluidAmount() + multipliedAmount <= this.output.getCapacity() && (productionType.neededFluid.isEmpty() || !this.catalyst.isEmpty() && productionType.neededFluid.getFluid().m_6212_(this.catalyst.getFluid().getFluid()) && this.catalyst.getFluidAmount() >= productionType.neededFluid.getAmount() * this.input.getFluidAmount() / 100);
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            ProductionType productionType = ProductionType.values()[this.production];
            int multipliedAmount = productionType.amount * this.input.getFluidAmount();
            FluidStack stack = OreTitaniumFluidAttributes.getFluidWithTag(ModuleCore.FERMENTED_ORE_MEAT, multipliedAmount, new ResourceLocation(OreTitaniumFluidAttributes.getFluidTag(this.input.getFluid())));
            this.output.fillForced(stack, IFluidHandler.FluidAction.EXECUTE);
            this.catalyst.drainForced(productionType.neededFluid.getAmount() * this.input.getFluidAmount() / 100, IFluidHandler.FluidAction.EXECUTE);
            this.input.drainForced(this.input.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
        };
    }

    @Override
    protected int getTickPower() {
        return FermentationStationConfig.powerPerTick;
    }

    @Override
    public int getMaxProgress() {
        return ProductionType.values()[this.production].ticks;
    }

    protected EnergyStorageComponent<FermentationStationTile> createEnergyStorage() {
        return new EnergyStorageComponent(FermentationStationConfig.maxStoredPower, 10, 20);
    }

    @Nonnull
    public FermentationStationTile getSelf() {
        return this;
    }

    public static enum SealType {
        FULL(sidedFluidTankComponent -> sidedFluidTankComponent.getFluidAmount() == sidedFluidTankComponent.getCapacity(), new StateButtonInfo(0, IndustrialAssetProvider.FERMENTATION_TANK_FULL, new String[]{"text.industrialforegoing.tooltip.fermentation_station.tank_full"})),
        HALF(sidedFluidTankComponent -> sidedFluidTankComponent.getFluidAmount() >= sidedFluidTankComponent.getCapacity() / 2, new StateButtonInfo(1, IndustrialAssetProvider.FERMENTATION_TANK_HALF, new String[]{"text.industrialforegoing.tooltip.fermentation_station.tank_half"})),
        ONE(sidedFluidTankComponent -> sidedFluidTankComponent.getFluidAmount() >= 1000, new StateButtonInfo(2, IndustrialAssetProvider.FERMENTATION_TANK_ONE, new String[]{"text.industrialforegoing.tooltip.fermentation_station.tank_one"}));

        private final Predicate<SidedFluidTankComponent> canSeal;
        private final StateButtonInfo info;

        private SealType(Predicate<SidedFluidTankComponent> canSeal, StateButtonInfo info) {
            this.canSeal = canSeal;
            this.info = info;
        }
    }

    public static enum ProductionType {
        X_2(2, FermentationStationConfig.ticksFor2XProduction, FluidStack.EMPTY, new StateButtonInfo(0, IndustrialAssetProvider.FERMENTATION_PROCESSING_TWO, new String[]{"text.industrialforegoing.tooltip.fermentation_station.processing_two"})),
        X_3(3, FermentationStationConfig.ticksFor3XProduction, FluidStack.EMPTY, new StateButtonInfo(1, IndustrialAssetProvider.FERMENTATION_PROCESSING_THREE, new String[]{"text.industrialforegoing.tooltip.fermentation_station.processing_three"})),
        X_4(4, FermentationStationConfig.ticksFor4XProduction, new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get(), 2), new StateButtonInfo(2, IndustrialAssetProvider.FERMENTATION_PROCESSING_FOUR, new String[]{"text.industrialforegoing.tooltip.fermentation_station.processing_four"})),
        X_5(5, FermentationStationConfig.ticksFor5XProduction, new FluidStack((Fluid)ModuleCore.ETHER.getSourceFluid().get(), 1), new StateButtonInfo(3, IndustrialAssetProvider.FERMENTATION_PROCESSING_FIVE, new String[]{"text.industrialforegoing.tooltip.fermentation_station.processing_five"}));

        private final int amount;
        private final int ticks;
        private final FluidStack neededFluid;
        private final StateButtonInfo info;

        private ProductionType(int amount, int ticks, FluidStack neededFluid, StateButtonInfo info) {
            this.amount = amount;
            this.ticks = ticks;
            this.neededFluid = neededFluid;
            this.info = info;
        }

        public int getTicks() {
            return this.ticks;
        }

        public FluidStack getNeededFluid() {
            return this.neededFluid;
        }
    }
}

