/*
 * Decompiled with CFR 0.152.
 */
package com.getitemfromblock.create_tweaked_controllers.packet;

import com.getitemfromblock.create_tweaked_controllers.block.TweakedLecternControllerBlockEntity;
import com.getitemfromblock.create_tweaked_controllers.item.ModItems;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public abstract class TweakedLinkedControllerPacketBase
extends SimplePacketBase {
    private BlockPos lecternPos;
    protected boolean useFullPrecision = false;

    public TweakedLinkedControllerPacketBase(BlockPos lecternPos) {
        this.lecternPos = lecternPos;
    }

    public TweakedLinkedControllerPacketBase(FriendlyByteBuf buffer) {
        byte val = buffer.readByte();
        if ((val & 1) != 0) {
            this.lecternPos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
        this.useFullPrecision = (val & 2) != 0;
    }

    protected boolean inLectern() {
        return this.lecternPos != null;
    }

    public void write(FriendlyByteBuf buffer) {
        byte mask = (byte)((this.inLectern() ? 1 : 0) | (this.useFullPrecision ? 2 : 0));
        buffer.writeByte((int)mask);
        if (this.inLectern()) {
            buffer.writeInt(this.lecternPos.m_123341_());
            buffer.writeInt(this.lecternPos.m_123342_());
            buffer.writeInt(this.lecternPos.m_123343_());
        }
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            if (this.inLectern()) {
                BlockEntity be = player.f_19853_.m_7702_(this.lecternPos);
                if (!(be instanceof TweakedLecternControllerBlockEntity)) {
                    return;
                }
                this.handleLectern(player, (TweakedLecternControllerBlockEntity)be);
            } else {
                ItemStack controller = player.m_21205_();
                if (!ModItems.TWEAKED_LINKED_CONTROLLER.isIn(controller) && !ModItems.TWEAKED_LINKED_CONTROLLER.isIn(controller = player.m_21206_())) {
                    return;
                }
                this.handleItem(player, controller);
            }
        });
        return true;
    }

    protected abstract void handleItem(ServerPlayer var1, ItemStack var2);

    protected abstract void handleLectern(ServerPlayer var1, TweakedLecternControllerBlockEntity var2);
}

