/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.client.adapter.ResourcePackAdapter;
import org.zeith.solarflux.RecipesSF;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.block.SolarPanelBlockItem;
import org.zeith.solarflux.client.SolarFluxResourcePack;
import org.zeith.solarflux.client.SolarPanelBakedModel;
import org.zeith.solarflux.items.ItemsSF;
import org.zeith.solarflux.items.JSItem;
import org.zeith.solarflux.net.SFNetwork;
import org.zeith.solarflux.panels.SolarPanels;
import org.zeith.solarflux.proxy.SFRClientProxy;
import org.zeith.solarflux.proxy.SFRCommonProxy;

@Mod(value="solarflux")
public class SolarFlux {
    public static final Logger LOG = LogManager.getLogger();
    public static final SFRCommonProxy PROXY = (SFRCommonProxy)DistExecutor.unsafeRunForDist(() -> SFRClientProxy::new, () -> SFRCommonProxy::new);
    public static final CreativeModeTab ITEM_GROUP = new CreativeModeTab("solarflux"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ItemsSF.PHOTOVOLTAIC_CELL_3);
        }
    };
    private static final List<JSItem.FutureJSGenerator> ITEMS2REG = new ArrayList<JSItem.FutureJSGenerator>();
    private static final List<JSItem> JS_MATERIALS_INTERNAL = new ArrayList<JSItem>();
    public static final List<JSItem> JS_MATERIALS = Collections.unmodifiableList(JS_MATERIALS_INTERNAL);

    public SolarFlux() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        HammerLib.EVENT_BUS.addListener(RecipesSF::addRecipes);
        SolarPanels.init();
        ResourcePackAdapter.registerResourcePack((PackResources)SolarFluxResourcePack.getPackInstance());
    }

    public static ItemLike newJSItem(String name) {
        JSItem.FutureJSGenerator gen = new JSItem.FutureJSGenerator(name);
        ITEMS2REG.add(gen);
        return gen;
    }

    @SubscribeEvent
    public void startServer(RegisterCommandsEvent e) {
        e.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"solarflux").then(Commands.m_82127_((String)"reload").executes(src -> {
            SolarPanels.refreshConfigs();
            ((CommandSourceStack)src.getSource()).m_81377_().m_6846_().m_11314_().forEach(SFNetwork::sendAllPanels);
            return 1;
        })));
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        Player player = e.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            LOG.info("Sending solar panels to " + sp.m_36316_().getName() + ".");
            SFNetwork.sendAllPanels(sp);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public void commonSetup(FMLCommonSetupEvent e) {
            PROXY.commonSetup();
            SFNetwork.init();
        }

        @SubscribeEvent
        public void loadComplete(FMLLoadCompleteEvent e) {
            SolarPanels.refreshConfigs();
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void clientSetup(FMLClientSetupEvent e) {
            PROXY.clientSetup();
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void modelBake(ModelBakeEvent e) {
            SolarPanels.listPanelBlocks().forEach(spb -> e.getModelRegistry().put(new ModelResourceLocation(spb.getRegistryName(), ""), new SolarPanelBakedModel((SolarPanelBlock)((Object)spb))));
        }

        @SubscribeEvent
        public static void registerTiles(RegistryEvent.Register<BlockEntityType<?>> e) {
            e.getRegistry().register(SolarPanels.SOLAR_PANEL_TYPE);
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> e) {
            SolarPanels.listPanelBlocks().forEach(arg_0 -> ((IForgeRegistry)e.getRegistry()).register(arg_0));
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> e) {
            IForgeRegistry r = e.getRegistry();
            ITEMS2REG.forEach(f -> {
                JSItem jsi = f.create();
                r.register((IForgeRegistryEntry)jsi);
                JS_MATERIALS_INTERNAL.add(jsi);
            });
            ItemsSF.register((IForgeRegistry<Item>)r);
            SolarPanels.listPanelBlocks().forEach(b -> {
                SolarPanelBlockItem item = new SolarPanelBlockItem((SolarPanelBlock)((Object)b), new Item.Properties().m_41491_(ITEM_GROUP));
                r.register((IForgeRegistryEntry)item);
            });
        }
    }
}

