/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;

public final class RecipeUtil {
    private RecipeUtil() {
    }

    public static ShapedTemplate getTemplate(JsonObject json) {
        HashMap ingMap = Maps.newHashMap();
        for (Map.Entry entry : GsonHelper.m_13930_((JsonObject)json, (String)"key").entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            ingMap.put(Character.valueOf(((String)entry.getKey()).charAt(0)), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        ingMap.put(Character.valueOf(' '), Ingredient.f_43901_);
        JsonArray patternJ = GsonHelper.m_13933_((JsonObject)json, (String)"pattern");
        if (patternJ.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        String[] pattern = new String[patternJ.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line = GsonHelper.m_13805_((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
            if (x > 0 && pattern[0].length() != line.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
            }
            pattern[x] = line;
        }
        int width = pattern[0].length();
        int height = pattern.length;
        NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
        HashSet missingKeys = Sets.newHashSet(ingMap.keySet());
        missingKeys.remove(Character.valueOf(' '));
        int i = 0;
        for (String line : pattern) {
            for (char chr : line.toCharArray()) {
                Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                if (ing == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                ingredients.set(i++, (Object)ing);
                missingKeys.remove(Character.valueOf(chr));
            }
        }
        if (!missingKeys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + missingKeys);
        }
        return new ShapedTemplate(width, height, (NonNullList<Ingredient>)ingredients);
    }

    public static ComputerFamily getFamily(JsonObject json, String name) {
        String familyName = GsonHelper.m_13906_((JsonObject)json, (String)name);
        for (ComputerFamily family : ComputerFamily.values()) {
            if (!family.name().equalsIgnoreCase(familyName)) continue;
            return family;
        }
        throw new JsonSyntaxException("Unknown computer family '" + familyName + "' for field " + name);
    }

    public record ShapedTemplate(int width, int height, NonNullList<Ingredient> ingredients) {
    }
}

