/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonObject;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.computer.blocks.BlockComputer;
import dan200.computercraft.shared.peripheral.diskdrive.BlockDiskDrive;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveState;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.BlockWiredModemFull;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wireless.BlockWirelessModem;
import dan200.computercraft.shared.peripheral.monitor.BlockMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.peripheral.printer.BlockPrinter;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import dan200.computercraft.shared.util.DirectionUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

class BlockModelGenerator {
    private static final ModelTemplate MONITOR_BASE = new ModelTemplate(Optional.of(new ResourceLocation("computercraft", "block/monitor_base")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125873_, TextureSlot.f_125875_, TextureSlot.f_125872_, TextureSlot.f_125874_});
    private static final ModelTemplate MODEM = new ModelTemplate(Optional.of(new ResourceLocation("computercraft", "block/modem")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125873_, TextureSlot.f_125874_});
    private static final ModelTemplate TURTLE = new ModelTemplate(Optional.of(new ResourceLocation("computercraft", "block/turtle_base")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
    private static final ModelTemplate TURTLE_UPGRADE_LEFT = new ModelTemplate(Optional.of(new ResourceLocation("computercraft", "block/turtle_upgrade_base_left")), Optional.of("_left"), new TextureSlot[]{TextureSlot.f_125868_});
    private static final ModelTemplate TURTLE_UPGRADE_RIGHT = new ModelTemplate(Optional.of(new ResourceLocation("computercraft", "block/turtle_upgrade_base_right")), Optional.of("_left"), new TextureSlot[]{TextureSlot.f_125868_});
    private static final BooleanProperty[] CABLE_DIRECTIONS = new BooleanProperty[]{BlockCable.DOWN, BlockCable.UP, BlockCable.NORTH, BlockCable.SOUTH, BlockCable.WEST, BlockCable.EAST};
    private static final boolean[] BOOLEANS = new boolean[]{false, true};

    BlockModelGenerator() {
    }

    public static void addBlockModels(BlockModelGenerators generators) {
        BlockModelGenerator.registerComputer(generators, (BlockComputer)Registry.ModBlocks.COMPUTER_NORMAL.get());
        BlockModelGenerator.registerComputer(generators, (BlockComputer)Registry.ModBlocks.COMPUTER_ADVANCED.get());
        BlockModelGenerator.registerComputer(generators, (BlockComputer)Registry.ModBlocks.COMPUTER_COMMAND.get());
        BlockModelGenerator.registerTurtle(generators, (BlockTurtle)Registry.ModBlocks.TURTLE_NORMAL.get());
        BlockModelGenerator.registerTurtle(generators, (BlockTurtle)Registry.ModBlocks.TURTLE_ADVANCED.get());
        BlockModelGenerator.registerWirelessModem(generators, (BlockWirelessModem)((Object)Registry.ModBlocks.WIRELESS_MODEM_NORMAL.get()));
        BlockModelGenerator.registerWirelessModem(generators, (BlockWirelessModem)((Object)Registry.ModBlocks.WIRELESS_MODEM_ADVANCED.get()));
        BlockModelGenerator.registerWiredModems(generators);
        BlockModelGenerator.registerMonitor(generators, (BlockMonitor)((Object)Registry.ModBlocks.MONITOR_NORMAL.get()));
        BlockModelGenerator.registerMonitor(generators, (BlockMonitor)((Object)Registry.ModBlocks.MONITOR_ADVANCED.get()));
        generators.m_124744_((Block)Registry.ModBlocks.SPEAKER.get(), TexturedModel.f_125911_);
        BlockModelGenerator.registerDiskDrive(generators);
        BlockModelGenerator.registerPrinter(generators);
        BlockModelGenerator.registerCable(generators);
        BlockModelGenerator.registerTurtleUpgrade(generators, "block/turtle_crafting_table", "block/turtle_crafty_face");
        BlockModelGenerator.registerTurtleUpgrade(generators, "block/turtle_speaker", "block/turtle_speaker_face");
        BlockModelGenerator.registerTurtleModem(generators, "block/turtle_modem_normal", "block/wireless_modem_normal_face");
        BlockModelGenerator.registerTurtleModem(generators, "block/turtle_modem_advanced", "block/wireless_modem_advanced_face");
    }

    private static void registerDiskDrive(BlockModelGenerators generators) {
        BlockDiskDrive diskDrive = (BlockDiskDrive)((Object)Registry.ModBlocks.DISK_DRIVE.get());
        generators.f_124477_.accept(MultiVariantGenerator.m_125254_((Block)diskDrive).m_125271_(BlockModelGenerator.createHorizontalFacingDispatch()).m_125271_(BlockModelGenerator.createModelDispatch(BlockDiskDrive.STATE, value -> ModelTemplates.f_125698_.m_125596_((Block)diskDrive, "_" + value.m_7912_(), TextureMapping.m_125846_((Block)diskDrive).m_125758_(TextureSlot.f_125873_, TextureMapping.m_125753_((Block)diskDrive, (String)(switch (value) {
            case DiskDriveState.EMPTY -> "_front";
            case DiskDriveState.INVALID -> "_front_rejected";
            case DiskDriveState.FULL -> "_front_accepted";
            default -> throw new IllegalArgumentException();
        }))), generators.f_124478_))));
        generators.m_124797_((Block)diskDrive, ModelLocationUtils.m_125578_((Block)diskDrive, (String)"_empty"));
    }

    private static void registerPrinter(BlockModelGenerators generators) {
        BlockPrinter printer = (BlockPrinter)((Object)Registry.ModBlocks.PRINTER.get());
        generators.f_124477_.accept(MultiVariantGenerator.m_125254_((Block)printer).m_125271_(BlockModelGenerator.createHorizontalFacingDispatch()).m_125271_(BlockModelGenerator.createModelDispatch(BlockPrinter.TOP, BlockPrinter.BOTTOM, (top, bottom) -> {
            String texture;
            String model;
            if (top.booleanValue() && bottom.booleanValue()) {
                model = "_both_full";
                texture = "_both_trays";
            } else if (top.booleanValue()) {
                model = "_top_full";
                texture = "_top_tray";
            } else if (bottom.booleanValue()) {
                model = "_bottom_full";
                texture = "_bottom_tray";
            } else {
                model = "_empty";
                texture = "_empty";
            }
            return ModelTemplates.f_125698_.m_125596_((Block)printer, model, TextureMapping.m_125846_((Block)printer).m_125758_(TextureSlot.f_125873_, TextureMapping.m_125753_((Block)printer, (String)("_front" + texture))), generators.f_124478_);
        })));
        generators.m_124797_((Block)printer, ModelLocationUtils.m_125578_((Block)printer, (String)"_empty"));
    }

    private static void registerComputer(BlockModelGenerators generators, BlockComputer<?> block) {
        generators.f_124477_.accept(MultiVariantGenerator.m_125254_(block).m_125271_(BlockModelGenerator.createHorizontalFacingDispatch()).m_125271_(BlockModelGenerator.createModelDispatch(BlockComputer.STATE, state -> ModelTemplates.f_125698_.m_125596_((Block)block, "_" + state.m_7912_(), TextureMapping.m_125846_((Block)block).m_125758_(TextureSlot.f_125873_, TextureMapping.m_125753_((Block)block, (String)("_front" + state.getTexture()))), generators.f_124478_))));
        generators.m_124797_(block, ModelLocationUtils.m_125578_(block, (String)"_blinking"));
    }

    private static void registerTurtle(BlockModelGenerators generators, BlockTurtle block) {
        ResourceLocation model = TURTLE.m_125592_((Block)block, TextureMapping.m_125768_((Block)block), generators.f_124478_);
        generators.f_124477_.accept(MultiVariantGenerator.m_125256_((Block)block, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model)).m_125271_(BlockModelGenerator.createHorizontalFacingDispatch()));
        generators.f_124478_.accept(ModelLocationUtils.m_125571_((Item)block.m_5456_()), () -> {
            JsonObject out = new JsonObject();
            out.addProperty("loader", "computercraft:turtle");
            out.addProperty("model", model.toString());
            return out;
        });
    }

    private static void registerWirelessModem(BlockModelGenerators generators, BlockWirelessModem block) {
        generators.f_124477_.accept(MultiVariantGenerator.m_125254_((Block)block).m_125271_(BlockModelGenerator.createFacingDispatch()).m_125271_(BlockModelGenerator.createModelDispatch(BlockWirelessModem.ON, on -> BlockModelGenerator.modemModel(generators, ModelLocationUtils.m_125578_((Block)block, (String)(on != false ? "_on" : "_off")), TextureMapping.m_125753_((Block)block, (String)("_face" + (on != false ? "_on" : "")))))));
        generators.m_124797_((Block)block, ModelLocationUtils.m_125578_((Block)block, (String)"_off"));
    }

    private static void registerWiredModems(BlockModelGenerators generators) {
        BlockWiredModemFull fullBlock = (BlockWiredModemFull)((Object)Registry.ModBlocks.WIRED_MODEM_FULL.get());
        generators.f_124477_.accept(MultiVariantGenerator.m_125254_((Block)fullBlock).m_125271_(BlockModelGenerator.createModelDispatch(BlockWiredModemFull.MODEM_ON, BlockWiredModemFull.PERIPHERAL_ON, (on, peripheral) -> {
            String suffix = (on != false ? "_on" : "_off") + (peripheral != false ? "_peripheral" : "");
            ResourceLocation faceTexture = new ResourceLocation("computercraft", "block/wired_modem_face" + (peripheral != false ? "_peripheral" : "") + (on != false ? "_on" : ""));
            BlockModelGenerator.modemModel(generators, new ResourceLocation("computercraft", "block/wired_modem" + suffix), faceTexture);
            return ModelTemplates.f_125692_.m_125612_(ModelLocationUtils.m_125578_((Block)fullBlock, (String)suffix), new TextureMapping().m_125758_(TextureSlot.f_125867_, faceTexture), generators.f_124478_);
        })));
        generators.m_124797_((Block)fullBlock, ModelLocationUtils.m_125578_((Block)fullBlock, (String)"_off"));
        generators.m_124519_((Item)Registry.ModItems.WIRED_MODEM.get(), new ResourceLocation("computercraft", "block/wired_modem_off"));
    }

    private static ResourceLocation modemModel(BlockModelGenerators generators, ResourceLocation name, ResourceLocation texture) {
        return MODEM.m_125612_(name, new TextureMapping().m_125758_(TextureSlot.f_125873_, texture).m_125758_(TextureSlot.f_125874_, new ResourceLocation("computercraft", "block/modem_back")), generators.f_124478_);
    }

    private static void registerMonitor(BlockModelGenerators generators, BlockMonitor block) {
        BlockModelGenerator.monitorModel(generators, block, "", 16, 4, 0, 32);
        BlockModelGenerator.monitorModel(generators, block, "_d", 20, 7, 0, 36);
        BlockModelGenerator.monitorModel(generators, block, "_l", 19, 4, 1, 33);
        BlockModelGenerator.monitorModel(generators, block, "_ld", 31, 7, 1, 45);
        BlockModelGenerator.monitorModel(generators, block, "_lr", 18, 4, 2, 34);
        BlockModelGenerator.monitorModel(generators, block, "_lrd", 30, 7, 2, 46);
        BlockModelGenerator.monitorModel(generators, block, "_lru", 24, 5, 2, 40);
        BlockModelGenerator.monitorModel(generators, block, "_lrud", 27, 6, 2, 43);
        BlockModelGenerator.monitorModel(generators, block, "_lu", 25, 5, 1, 39);
        BlockModelGenerator.monitorModel(generators, block, "_lud", 28, 6, 1, 42);
        BlockModelGenerator.monitorModel(generators, block, "_r", 17, 4, 3, 35);
        BlockModelGenerator.monitorModel(generators, block, "_rd", 29, 7, 3, 47);
        BlockModelGenerator.monitorModel(generators, block, "_ru", 23, 5, 3, 41);
        BlockModelGenerator.monitorModel(generators, block, "_rud", 26, 6, 3, 44);
        BlockModelGenerator.monitorModel(generators, block, "_u", 22, 5, 0, 38);
        BlockModelGenerator.monitorModel(generators, block, "_ud", 21, 6, 0, 37);
        generators.f_124477_.accept(MultiVariantGenerator.m_125254_((Block)block).m_125271_(BlockModelGenerator.createHorizontalFacingDispatch()).m_125271_(BlockModelGenerator.createVerticalFacingDispatch((Property<Direction>)BlockMonitor.ORIENTATION)).m_125271_(BlockModelGenerator.createModelDispatch(BlockMonitor.STATE, edge -> ModelLocationUtils.m_125578_((Block)block, (String)(edge == MonitorEdgeState.NONE ? "" : "_" + edge.m_7912_())))));
        generators.m_124797_((Block)block, BlockModelGenerator.monitorModel(generators, block, "_item", 15, 4, 0, 32));
    }

    private static ResourceLocation monitorModel(BlockModelGenerators generators, BlockMonitor block, String corners, int front, int side, int top, int back) {
        return MONITOR_BASE.m_125612_(ModelLocationUtils.m_125578_((Block)block, (String)corners), new TextureMapping().m_125758_(TextureSlot.f_125873_, TextureMapping.m_125753_((Block)block, (String)("_" + front))).m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)block, (String)("_" + side))).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)block, (String)("_" + top))).m_125758_(TextureSlot.f_125874_, TextureMapping.m_125753_((Block)block, (String)("_" + back))), generators.f_124478_);
    }

    private static void registerCable(BlockModelGenerators generators) {
        MultiPartGenerator generator = MultiPartGenerator.m_125204_((Block)((Block)Registry.ModBlocks.CABLE.get()));
        ResourceLocation coreFacing = new ResourceLocation("computercraft", "block/cable_core_facing");
        generator.m_125209_(Condition.m_125137_((Condition[])new Condition[]{BlockModelGenerator.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST).m_125176_((Property)BlockCable.UP, (Comparable)Boolean.valueOf(true)), BlockModelGenerator.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST).m_125176_((Property)BlockCable.DOWN, (Comparable)Boolean.valueOf(true))}), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)coreFacing).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90));
        generator.m_125209_(Condition.m_125137_((Condition[])new Condition[]{BlockModelGenerator.cableNoNeighbour(Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST), BlockModelGenerator.cableNoNeighbour(Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST).m_125176_((Property)BlockCable.NORTH, (Comparable)Boolean.valueOf(true)), BlockModelGenerator.cableNoNeighbour(Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST).m_125176_((Property)BlockCable.SOUTH, (Comparable)Boolean.valueOf(true))}), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)coreFacing).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R0));
        generator.m_125209_(Condition.m_125137_((Condition[])new Condition[]{BlockModelGenerator.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN).m_125176_((Property)BlockCable.EAST, (Comparable)Boolean.valueOf(true)), BlockModelGenerator.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN).m_125176_((Property)BlockCable.WEST, (Comparable)Boolean.valueOf(true))}), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)coreFacing).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90));
        ResourceLocation core = new ResourceLocation("computercraft", "block/cable_core_any");
        ArrayList<Condition.TerminalCondition> rightAngles = new ArrayList<Condition.TerminalCondition>();
        for (int i = 0; i < DirectionUtil.FACINGS.length; ++i) {
            for (int j = i; j < DirectionUtil.FACINGS.length; ++j) {
                if (DirectionUtil.FACINGS[i].m_122434_() == DirectionUtil.FACINGS[j].m_122434_()) continue;
                rightAngles.add(new Condition.TerminalCondition().m_125176_((Property)BlockCable.CABLE, (Comparable)Boolean.valueOf(true)).m_125176_((Property)CABLE_DIRECTIONS[i], (Comparable)Boolean.valueOf(true)).m_125176_((Property)CABLE_DIRECTIONS[j], (Comparable)Boolean.valueOf(true)));
            }
        }
        generator.m_125209_(Condition.m_125137_((Condition[])rightAngles.toArray(new Condition[0])), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)core));
        ResourceLocation arm = new ResourceLocation("computercraft", "block/cable_arm");
        for (Direction direction : DirectionUtil.FACINGS) {
            generator.m_125209_((Condition)new Condition.TerminalCondition().m_125176_((Property)CABLE_DIRECTIONS[direction.ordinal()], (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)arm).m_125511_(VariantProperties.f_125518_, (Object)BlockModelGenerator.toXAngle(direction.m_122424_())).m_125511_(VariantProperties.f_125519_, (Object)BlockModelGenerator.toYAngle(direction.m_122424_())));
        }
        for (Direction direction : DirectionUtil.FACINGS) {
            for (boolean on : BOOLEANS) {
                for (boolean peripheral : BOOLEANS) {
                    String suffix = (on ? "_on" : "_off") + (peripheral ? "_peripheral" : "");
                    generator.m_125209_((Condition)new Condition.TerminalCondition().m_125176_(BlockCable.MODEM, (Comparable)((Object)CableModemVariant.from(direction, on, peripheral))), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)new ResourceLocation("computercraft", "block/wired_modem" + suffix)).m_125511_(VariantProperties.f_125518_, (Object)BlockModelGenerator.toXAngle(direction)).m_125511_(VariantProperties.f_125519_, (Object)BlockModelGenerator.toYAngle(direction)));
                }
            }
        }
        generators.f_124477_.accept(generator);
    }

    private static Condition.TerminalCondition cableNoNeighbour(Direction ... directions) {
        Condition.TerminalCondition condition = new Condition.TerminalCondition().m_125176_((Property)BlockCable.CABLE, (Comparable)Boolean.valueOf(true));
        for (Direction direction : directions) {
            condition.m_125176_((Property)CABLE_DIRECTIONS[direction.ordinal()], (Comparable)Boolean.valueOf(false));
        }
        return condition;
    }

    private static void registerTurtleUpgrade(BlockModelGenerators generators, String name, String texture) {
        TURTLE_UPGRADE_LEFT.m_125612_(new ResourceLocation("computercraft", name + "_left"), TextureMapping.m_125761_((ResourceLocation)new ResourceLocation("computercraft", texture)), generators.f_124478_);
        TURTLE_UPGRADE_RIGHT.m_125612_(new ResourceLocation("computercraft", name + "_right"), TextureMapping.m_125761_((ResourceLocation)new ResourceLocation("computercraft", texture)), generators.f_124478_);
    }

    private static void registerTurtleModem(BlockModelGenerators generators, String name, String texture) {
        BlockModelGenerator.registerTurtleUpgrade(generators, name + "_off", texture);
        BlockModelGenerator.registerTurtleUpgrade(generators, name + "_on", texture + "_on");
    }

    private static VariantProperties.Rotation toXAngle(Direction direction) {
        switch (direction) {
            default: {
                return VariantProperties.Rotation.R0;
            }
            case UP: {
                return VariantProperties.Rotation.R270;
            }
            case DOWN: 
        }
        return VariantProperties.Rotation.R90;
    }

    private static VariantProperties.Rotation toYAngle(Direction direction) {
        switch (direction) {
            default: {
                return VariantProperties.Rotation.R0;
            }
            case NORTH: {
                return VariantProperties.Rotation.R0;
            }
            case SOUTH: {
                return VariantProperties.Rotation.R180;
            }
            case EAST: {
                return VariantProperties.Rotation.R90;
            }
            case WEST: 
        }
        return VariantProperties.Rotation.R270;
    }

    private static PropertyDispatch createHorizontalFacingDispatch() {
        PropertyDispatch.C1 dispatch = PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61374_);
        for (Direction direction : BlockStateProperties.f_61374_.m_6908_()) {
            dispatch.m_125329_((Comparable)direction, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)BlockModelGenerator.toYAngle(direction)));
        }
        return dispatch;
    }

    private static PropertyDispatch createVerticalFacingDispatch(Property<Direction> property) {
        PropertyDispatch.C1 dispatch = PropertyDispatch.m_125294_(property);
        for (Direction direction : property.m_6908_()) {
            dispatch.m_125329_((Comparable)direction, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)BlockModelGenerator.toXAngle(direction)));
        }
        return dispatch;
    }

    private static PropertyDispatch createFacingDispatch() {
        PropertyDispatch.C1 dispatch = PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61372_);
        for (Direction direction : BlockStateProperties.f_61372_.m_6908_()) {
            dispatch.m_125329_((Comparable)direction, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)BlockModelGenerator.toYAngle(direction)).m_125511_(VariantProperties.f_125518_, (Object)BlockModelGenerator.toXAngle(direction)));
        }
        return dispatch;
    }

    private static <T extends Comparable<T>> PropertyDispatch createModelDispatch(Property<T> property, Function<T, ResourceLocation> makeModel) {
        PropertyDispatch.C1 variant = PropertyDispatch.m_125294_(property);
        for (Comparable value : property.m_6908_()) {
            variant.m_125329_(value, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)makeModel.apply(value)));
        }
        return variant;
    }

    private static <T extends Comparable<T>, U extends Comparable<U>> PropertyDispatch createModelDispatch(Property<T> propertyT, Property<U> propertyU, BiFunction<T, U, ResourceLocation> makeModel) {
        PropertyDispatch.C2 variant = PropertyDispatch.m_125296_(propertyT, propertyU);
        for (Comparable valueT : propertyT.m_6908_()) {
            for (Comparable valueU : propertyU.m_6908_()) {
                variant.m_125350_(valueT, valueU, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)makeModel.apply(valueT, valueU)));
            }
        }
        return variant;
    }
}

