/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.computer.ComputerSide;

public class RedstoneAPI
implements ILuaAPI {
    private final IAPIEnvironment environment;

    public RedstoneAPI(IAPIEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public String[] getNames() {
        return new String[]{"rs", "redstone"};
    }

    @LuaFunction
    public final String[] getSides() {
        return ComputerSide.NAMES;
    }

    @LuaFunction
    public final void setOutput(ComputerSide side, boolean on) {
        this.environment.setOutput(side, on ? 15 : 0);
    }

    @LuaFunction
    public final boolean getOutput(ComputerSide side) {
        return this.environment.getOutput(side) > 0;
    }

    @LuaFunction
    public final boolean getInput(ComputerSide side) {
        return this.environment.getInput(side) > 0;
    }

    @LuaFunction(value={"setAnalogOutput", "setAnalogueOutput"})
    public final void setAnalogOutput(ComputerSide side, int value) throws LuaException {
        if (value < 0 || value > 15) {
            throw new LuaException("Expected number in range 0-15");
        }
        this.environment.setOutput(side, value);
    }

    @LuaFunction(value={"getAnalogOutput", "getAnalogueOutput"})
    public final int getAnalogOutput(ComputerSide side) {
        return this.environment.getOutput(side);
    }

    @LuaFunction(value={"getAnalogInput", "getAnalogueInput"})
    public final int getAnalogInput(ComputerSide side) {
        return this.environment.getInput(side);
    }

    @LuaFunction
    public final void setBundledOutput(ComputerSide side, int output) {
        this.environment.setBundledOutput(side, output);
    }

    @LuaFunction
    public final int getBundledOutput(ComputerSide side) {
        return this.environment.getBundledOutput(side);
    }

    @LuaFunction
    public final int getBundledInput(ComputerSide side) {
        return this.environment.getBundledInput(side);
    }

    @LuaFunction
    public final boolean testBundledInput(ComputerSide side, int mask) {
        int input = this.environment.getBundledInput(side);
        return (input & mask) == mask;
    }
}

