/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.lib.doubles;

import cc.tweaked.internal.cobalt.lib.doubles.Assert;
import cc.tweaked.internal.cobalt.lib.doubles.DiyFp;
import cc.tweaked.internal.cobalt.lib.doubles.UnsignedValues;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.Unsigned;
import org.checkerframework.common.value.qual.UnknownVal;

public final class Ieee {
    private Ieee() {
    }

    public static class Double {
        public static final @Unsigned @UnknownVal long SIGN_MASK = Long.MIN_VALUE;
        public static final @Unsigned @UnknownVal long EXPONENT_MASK = 0x7FF0000000000000L;
        public static final @Unsigned @UnknownVal long SIGNIFICAND_MASK = 0xFFFFFFFFFFFFFL;
        public static final @Unsigned @UnknownVal long HIDDEN_BIT = 0x10000000000000L;
        public static final @Unsigned @UnknownVal long QUIET_NAN_BIT = 0x8000000000000L;
        public static final @UnknownVal @Signed int PHYSICAL_SIGNIFICAND_SIZE = 52;
        public static final @UnknownVal @Signed int SIGNIFICAND_SIZE = 53;
        public static final @UnknownVal @Signed int EXPONENT_BIAS = 1075;
        public static final @UnknownVal @Signed int MAX_EXPONENT = 972;
        private static final @UnknownVal @Signed int DENORMAL_EXPONENT = -1074;
        private static final @Unsigned @UnknownVal long INFINITY = 0x7FF0000000000000L;
        private static final @Unsigned @UnknownVal long NAN = 9221120237041090560L;
        private final @Unsigned @UnknownVal long bits;

        public Double() {
            this.bits = 0L;
        }

        public Double(@UnknownVal @Signed double d) {
            this.bits = java.lang.Double.doubleToRawLongBits(d);
        }

        public Double(@Unsigned @UnknownVal long d64) {
            this.bits = d64;
        }

        public Double(@UnknownVal @Signed DiyFp diyFp) {
            this.bits = Double.diyFpToUint64(diyFp);
        }

        public @UnknownVal @Signed DiyFp asDiyFp() {
            Assert.requireState(this.sign() > 0, "instance must be positive");
            Assert.requireState(!this.isSpecial(), "must not be special");
            return new DiyFp(this.significand(), this.exponent());
        }

        public @UnknownVal @Signed DiyFp asNormalizedDiyFp() {
            Assert.requireState(this.value() > 0.0, "instance must be positive");
            @Unsigned long f = this.significand();
            int e = this.exponent();
            while ((f & 0x10000000000000L) == 0L) {
                f <<= 1;
                --e;
            }
            return new DiyFp(f <<= 11, e -= 11);
        }

        public @Unsigned @UnknownVal long asUint64() {
            return this.bits;
        }

        public @UnknownVal @Signed double nextDouble() {
            if (this.bits == 0x7FF0000000000000L) {
                return new Double(0x7FF0000000000000L).value();
            }
            if (this.sign() < 0 && this.significand() == 0L) {
                return 0.0;
            }
            if (this.sign() < 0) {
                return new Double(this.bits - 1L).value();
            }
            return new Double(this.bits + 1L).value();
        }

        public @UnknownVal @Signed double previousDouble() {
            if (this.bits == -4503599627370496L) {
                return -Double.infinity();
            }
            if (this.sign() < 0) {
                return new Double(this.bits + 1L).value();
            }
            if (this.significand() == 0L) {
                return -0.0;
            }
            return new Double(this.bits - 1L).value();
        }

        public @UnknownVal @Signed int exponent() {
            if (this.isDenormal()) {
                return -1074;
            }
            long d64 = this.asUint64();
            int biasedE = (int)((d64 & 0x7FF0000000000000L) >> 52);
            return biasedE - 1075;
        }

        public @Unsigned @UnknownVal long significand() {
            @Unsigned long d64 = this.asUint64();
            @Unsigned long significand = d64 & 0xFFFFFFFFFFFFFL;
            if (!this.isDenormal()) {
                return significand + 0x10000000000000L;
            }
            return significand;
        }

        public @UnknownVal @Signed boolean isDenormal() {
            long d64 = this.asUint64();
            return (d64 & 0x7FF0000000000000L) == 0L;
        }

        public @UnknownVal @Signed boolean isSpecial() {
            long d64 = this.asUint64();
            return (d64 & 0x7FF0000000000000L) == 0x7FF0000000000000L;
        }

        public @UnknownVal @Signed boolean isNan() {
            long d64 = this.asUint64();
            return (d64 & 0x7FF0000000000000L) == 0x7FF0000000000000L && (d64 & 0xFFFFFFFFFFFFFL) != 0L;
        }

        public @UnknownVal @Signed boolean isQuietNan() {
            return this.isNan() && (this.asUint64() & 0x8000000000000L) != 0L;
        }

        public @UnknownVal @Signed boolean isSignalingNan() {
            return this.isNan() && (this.asUint64() & 0x8000000000000L) == 0L;
        }

        public @UnknownVal @Signed boolean isInfinite() {
            long d64 = this.asUint64();
            return (d64 & 0x7FF0000000000000L) == 0x7FF0000000000000L && (d64 & 0xFFFFFFFFFFFFFL) == 0L;
        }

        public @UnknownVal @Signed int sign() {
            long d64 = this.asUint64();
            return (d64 & Long.MIN_VALUE) == 0L ? 1 : -1;
        }

        public @UnknownVal @Signed DiyFp upperBoundary() {
            Assert.requireState(this.sign() > 0, "instance must be positive");
            return new DiyFp(this.significand() * 2L + 1L, this.exponent() - 1);
        }

        public void normalizedBoundaries(@UnknownVal @Signed DiyFp @UnknownVal @Signed [] outMMinus, @UnknownVal @Signed DiyFp @UnknownVal @Signed [] outMPlus) {
            Assert.requireState(this.value() > 0.0, "instance must be positive");
            DiyFp v = this.asDiyFp();
            DiyFp mPlus = DiyFp.normalize(new DiyFp((v.f() << 1) + 1L, v.e() - 1));
            DiyFp mMinus = this.lowerBoundaryIsCloser() ? new DiyFp((v.f() << 2) - 1L, v.e() - 2) : new DiyFp((v.f() << 1) - 1L, v.e() - 1);
            mMinus.setF(mMinus.f() << mMinus.e() - mPlus.e());
            mMinus.setE(mPlus.e());
            outMPlus[0] = mPlus;
            outMMinus[0] = mMinus;
        }

        public @UnknownVal @Signed boolean lowerBoundaryIsCloser() {
            boolean physicalSignificandIsZero = (this.asUint64() & 0xFFFFFFFFFFFFFL) == 0L;
            return physicalSignificandIsZero && this.exponent() != -1074;
        }

        public @UnknownVal @Signed double value() {
            return java.lang.Double.longBitsToDouble(this.bits);
        }

        public static @UnknownVal @Signed int significandSizeForOrderOfMagnitude(@UnknownVal @Signed int order) {
            if (order >= -1021) {
                return 53;
            }
            if (order <= -1074) {
                return 0;
            }
            return order - -1074;
        }

        public static @UnknownVal @Signed double infinity() {
            return new Double(0x7FF0000000000000L).value();
        }

        public static @UnknownVal @Signed double nan() {
            return new Double(9221120237041090560L).value();
        }

        private static @Unsigned @UnknownVal long diyFpToUint64(@UnknownVal @Signed DiyFp diyFp) {
            @Unsigned long significand = diyFp.f();
            int exponent = diyFp.e();
            while (UnsignedValues.ulongGT(significand, 0x1FFFFFFFFFFFFFL)) {
                significand >>>= 1;
                ++exponent;
            }
            if (exponent >= 972) {
                return 0x7FF0000000000000L;
            }
            if (exponent < -1074) {
                return 0L;
            }
            while (exponent > -1074 && (significand & 0x10000000000000L) == 0L) {
                significand <<= 1;
                --exponent;
            }
            long biasedExponent = exponent == -1074 && (significand & 0x10000000000000L) == 0L ? 0L : UnsignedValues.toUlong(exponent + 1075);
            return significand & 0xFFFFFFFFFFFFFL | biasedExponent << 52;
        }
    }
}

