/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.features.Locatables;
import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.implementations.menuobjects.IPortableTerminal;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.storage.IStorageService;
import appeng.api.storage.MEStorage;
import appeng.api.util.DimensionalBlockPos;
import appeng.api.util.IConfigManager;
import appeng.blockentity.networking.WirelessBlockEntity;
import appeng.core.AEConfig;
import appeng.core.localization.PlayerMessages;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.menu.ISubMenu;
import java.util.OptionalLong;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WirelessTerminalMenuHost
extends ItemMenuHost
implements IPortableTerminal,
IActionHost {
    private final WirelessTerminalItem terminal;
    private final BiConsumer<Player, ISubMenu> returnToMainMenu;
    private IGrid targetGrid;
    private IStorageService sg;
    private IWirelessAccessPoint myWap;
    private double sqRange = Double.MAX_VALUE;
    private double currentDistanceFromGrid = Double.MAX_VALUE;

    public WirelessTerminalMenuHost(Player player, @Nullable Integer slot, ItemStack itemStack, BiConsumer<Player, ISubMenu> returnToMainMenu) {
        super(player, slot, itemStack);
        IGridNode n;
        Item item = itemStack.m_41720_();
        if (!(item instanceof WirelessTerminalItem)) {
            throw new IllegalArgumentException("Can only use this class with subclasses of WirelessTerminalItem");
        }
        WirelessTerminalItem wirelessTerminalItem = (WirelessTerminalItem)item;
        this.terminal = wirelessTerminalItem;
        this.returnToMainMenu = returnToMainMenu;
        OptionalLong gridKey = this.terminal.getGridKey(itemStack);
        if (gridKey.isEmpty()) {
            return;
        }
        IActionHost actionHost = Locatables.securityStations().get(player.f_19853_, gridKey.getAsLong());
        if (actionHost != null && (n = actionHost.getActionableNode()) != null) {
            this.targetGrid = n.getGrid();
            this.sg = this.targetGrid.getStorageService();
        }
    }

    @Override
    public MEStorage getInventory() {
        return this.sg != null ? this.sg.getInventory() : null;
    }

    @Override
    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        if (this.terminal != null) {
            double extracted = Math.min(amt, this.terminal.getAECurrentPower(this.getItemStack()));
            if (mode == Actionable.SIMULATE) {
                return extracted;
            }
            return this.terminal.usePower(this.getPlayer(), extracted, this.getItemStack()) ? extracted : 0.0;
        }
        return 0.0;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.terminal.getConfigManager(this.getItemStack());
    }

    @Override
    public IGridNode getActionableNode() {
        this.rangeCheck();
        if (this.myWap != null) {
            return this.myWap.getActionableNode();
        }
        return null;
    }

    public boolean rangeCheck() {
        this.currentDistanceFromGrid = Double.MAX_VALUE;
        this.sqRange = Double.MAX_VALUE;
        if (this.targetGrid != null) {
            if (this.myWap != null) {
                return this.myWap.getGrid() == this.targetGrid && this.testWap(this.myWap);
            }
            for (WirelessBlockEntity wap : this.targetGrid.getMachines(WirelessBlockEntity.class)) {
                if (!this.testWap(wap)) continue;
                this.myWap = wap;
            }
            return this.myWap != null;
        }
        return false;
    }

    protected boolean testWap(IWirelessAccessPoint wap) {
        double offZ;
        double offY;
        double offX;
        double r;
        double rangeLimit = wap.getRange();
        rangeLimit *= rangeLimit;
        DimensionalBlockPos dc = wap.getLocation();
        if (dc.getLevel() == this.getPlayer().f_19853_ && (r = (offX = (double)dc.getPos().m_123341_() - this.getPlayer().m_20185_()) * offX + (offY = (double)dc.getPos().m_123342_() - this.getPlayer().m_20186_()) * offY + (offZ = (double)dc.getPos().m_123343_() - this.getPlayer().m_20189_()) * offZ) < rangeLimit && this.sqRange > r && wap.isActive()) {
            this.sqRange = r;
            this.currentDistanceFromGrid = Math.sqrt(r);
            return true;
        }
        return false;
    }

    @Override
    public boolean onBroadcastChanges(AbstractContainerMenu menu) {
        return super.onBroadcastChanges(menu) && this.checkWirelessRange(menu) && this.drainPower();
    }

    private boolean checkWirelessRange(AbstractContainerMenu menu) {
        if (!this.rangeCheck()) {
            if (!this.isClientSide()) {
                this.getPlayer().m_6352_((Component)PlayerMessages.OutOfRange.text(), Util.f_137441_);
            }
            return false;
        }
        this.setPowerDrainPerTick(AEConfig.instance().wireless_getDrainRate(this.currentDistanceFromGrid));
        return true;
    }

    @Override
    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        this.returnToMainMenu.accept(player, subMenu);
    }

    @Override
    public ItemStack getMainMenuIcon() {
        return this.getItemStack();
    }
}

