/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import com.google.common.math.IntMath;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyGeneratorBlockEntity
extends AEBaseBlockEntity
implements ServerTickingBlockEntity,
IEnergyStorage {
    private static final int BASE_ENERGY = 8;

    public EnergyGeneratorBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    public void serverTick() {
        Level level = this.m_58904_();
        int tier = 1;
        for (Direction facing : Direction.values()) {
            BlockEntity te = level.m_7702_(this.m_58899_().m_142300_(facing));
            if (!(te instanceof EnergyGeneratorBlockEntity)) continue;
            ++tier;
        }
        int energyToInsert = IntMath.pow((int)8, (int)tier);
        for (Direction facing : Direction.values()) {
            BlockEntity te = this.m_58904_().m_7702_(this.m_58899_().m_142300_(facing));
            if (te == null) continue;
            LazyOptional cap = te.getCapability(CapabilityEnergy.ENERGY, facing.m_122424_());
            cap.ifPresent(consumer -> {
                if (consumer.canReceive()) {
                    consumer.receiveEnergy(energyToInsert, false);
                }
            });
        }
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this);
        }
        return super.getCapability(capability, facing);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return maxExtract;
    }

    public int getEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public int getMaxEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }
}

