/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.recipes;

import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.BlockDefinition;
import appeng.datagen.providers.recipes.AE2RecipeProvider;
import appeng.datagen.providers.recipes.RecipeCriteria;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class DecorationRecipes
extends AE2RecipeProvider {
    BlockDefinition<?>[][] blocks = new BlockDefinition[][]{{AEBlocks.SKY_STONE_BLOCK, AEBlocks.SKY_STONE_SLAB, AEBlocks.SKY_STONE_STAIRS, AEBlocks.SKY_STONE_WALL}, {AEBlocks.SMOOTH_SKY_STONE_BLOCK, AEBlocks.SMOOTH_SKY_STONE_SLAB, AEBlocks.SMOOTH_SKY_STONE_STAIRS, AEBlocks.SMOOTH_SKY_STONE_WALL}, {AEBlocks.SKY_STONE_BRICK, AEBlocks.SKY_STONE_BRICK_SLAB, AEBlocks.SKY_STONE_BRICK_STAIRS, AEBlocks.SKY_STONE_BRICK_WALL}, {AEBlocks.SKY_STONE_SMALL_BRICK, AEBlocks.SKY_STONE_SMALL_BRICK_SLAB, AEBlocks.SKY_STONE_SMALL_BRICK_STAIRS, AEBlocks.SKY_STONE_SMALL_BRICK_WALL}, {AEBlocks.FLUIX_BLOCK, AEBlocks.FLUIX_SLAB, AEBlocks.FLUIX_STAIRS, AEBlocks.FLUIX_WALL}, {AEBlocks.QUARTZ_BLOCK, AEBlocks.QUARTZ_SLAB, AEBlocks.QUARTZ_STAIRS, AEBlocks.QUARTZ_WALL}, {AEBlocks.CHISELED_QUARTZ_BLOCK, AEBlocks.CHISELED_QUARTZ_SLAB, AEBlocks.CHISELED_QUARTZ_STAIRS, AEBlocks.CHISELED_QUARTZ_WALL}, {AEBlocks.QUARTZ_PILLAR, AEBlocks.QUARTZ_PILLAR_SLAB, AEBlocks.QUARTZ_PILLAR_STAIRS, AEBlocks.QUARTZ_PILLAR_WALL}};

    public DecorationRecipes(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    protected void buildAE2CraftingRecipes(Consumer<FinishedRecipe> consumer) {
        for (BlockDefinition<?>[] block : this.blocks) {
            this.slabRecipe(consumer, block[0], block[1]);
            this.stairRecipe(consumer, block[0], block[2]);
            this.wallRecipe(consumer, block[0], block[3]);
        }
    }

    private void slabRecipe(Consumer<FinishedRecipe> consumer, BlockDefinition<?> block, BlockDefinition<?> slabs) {
        Object inputBlock = block.block();
        Object outputBlock = slabs.block();
        ShapedRecipeBuilder.m_126118_(slabs.block(), (int)6).m_126130_("###").m_126127_(Character.valueOf('#'), inputBlock).m_142284_(RecipeCriteria.criterionName(block), (CriterionTriggerInstance)DecorationRecipes.m_125977_(inputBlock)).m_142700_(consumer, this.prefix("shaped/slabs/", block.id()));
        SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{inputBlock}), outputBlock, (int)2).m_142284_(RecipeCriteria.criterionName(block), (CriterionTriggerInstance)DecorationRecipes.m_125977_(inputBlock)).m_142700_(consumer, this.prefix("block_cutter/slabs/", slabs.id()));
    }

    private void stairRecipe(Consumer<FinishedRecipe> consumer, BlockDefinition<?> block, BlockDefinition<?> stairs) {
        Object inputBlock = block.block();
        Object outputBlock = stairs.block();
        ShapedRecipeBuilder.m_126118_(outputBlock, (int)4).m_126130_("#  ").m_126130_("## ").m_126130_("###").m_126127_(Character.valueOf('#'), inputBlock).m_142284_(RecipeCriteria.criterionName(block), (CriterionTriggerInstance)DecorationRecipes.m_125977_(inputBlock)).m_142700_(consumer, this.prefix("shaped/stairs/", block.id()));
        SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{inputBlock}), outputBlock).m_142284_(RecipeCriteria.criterionName(block), (CriterionTriggerInstance)DecorationRecipes.m_125977_(inputBlock)).m_142700_(consumer, this.prefix("block_cutter/stairs/", stairs.id()));
    }

    private void wallRecipe(Consumer<FinishedRecipe> consumer, BlockDefinition<?> block, BlockDefinition<?> wall) {
        Object inputBlock = block.block();
        Object outputBlock = wall.block();
        ShapedRecipeBuilder.m_126118_(outputBlock, (int)6).m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), inputBlock).m_142284_(RecipeCriteria.criterionName(block), (CriterionTriggerInstance)DecorationRecipes.m_125977_(inputBlock)).m_142700_(consumer, this.prefix("shaped/walls/", block.id()));
        SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{inputBlock}), outputBlock).m_142284_(RecipeCriteria.criterionName(block), (CriterionTriggerInstance)DecorationRecipes.m_125977_(inputBlock)).m_142700_(consumer, this.prefix("block_cutter/walls/", wall.id()));
    }

    private ResourceLocation prefix(String prefix, ResourceLocation id) {
        return new ResourceLocation(id.m_135827_(), prefix + id.m_135815_());
    }

    public String m_6055_() {
        return "Applied Energistics 2 Decorative Blocks";
    }
}

