/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;

class InvalidPatternHelper {
    private final List<PatternIngredient> outputs = new ArrayList<PatternIngredient>();
    private final List<PatternIngredient> inputs = new ArrayList<PatternIngredient>();
    private final boolean isCrafting;
    private final boolean canSubstitute;

    public InvalidPatternHelper(ItemStack is) {
        int i;
        CompoundTag encodedValue = is.m_41783_();
        if (encodedValue == null) {
            throw new IllegalArgumentException("No pattern here!");
        }
        ListTag inTag = encodedValue.m_128437_("in", 10);
        ListTag outTag = encodedValue.m_128437_("out", 10);
        this.isCrafting = encodedValue.m_128471_("crafting");
        this.canSubstitute = this.isCrafting && encodedValue.m_128471_("substitute");
        for (i = 0; i < outTag.size(); ++i) {
            this.outputs.add(new PatternIngredient(outTag.m_128728_(i)));
        }
        for (i = 0; i < inTag.size(); ++i) {
            CompoundTag in = inTag.m_128728_(i);
            if (in.m_128456_()) continue;
            this.inputs.add(new PatternIngredient(in));
        }
    }

    public List<PatternIngredient> getOutputs() {
        return this.outputs;
    }

    public List<PatternIngredient> getInputs() {
        return this.inputs;
    }

    public boolean isCraftable() {
        return this.isCrafting;
    }

    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    public static class PatternIngredient {
        private String id;
        private int count;
        private int damage;
        private ItemStack stack;

        public PatternIngredient(CompoundTag tag) {
            this.stack = ItemStack.m_41712_((CompoundTag)tag);
            if (this.stack.m_41619_()) {
                this.id = tag.m_128461_("id");
                this.count = tag.m_128445_("Count");
                this.damage = Math.max(0, tag.m_128448_("Damage"));
            }
        }

        public boolean isValid() {
            return !this.stack.m_41619_();
        }

        public Component getName() {
            return this.isValid() ? this.stack.m_41786_() : new TextComponent(this.id + "@" + this.getDamage());
        }

        public int getDamage() {
            return this.isValid() ? this.stack.m_41773_() : this.damage;
        }

        public int getCount() {
            return this.isValid() ? this.stack.m_41613_() : this.count;
        }

        public ItemStack getItem() {
            if (!this.isValid()) {
                throw new IllegalArgumentException("There is no valid ItemStack for this PatternIngredient");
            }
            return this.stack;
        }

        public Component getFormattedToolTip() {
            MutableComponent result = new TextComponent(this.getCount() + " ").m_7220_(this.getName());
            if (!this.isValid()) {
                result.m_130940_(ChatFormatting.RED);
            }
            return result;
        }
    }
}

