/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity;

import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.GenericStack;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.util.inv.InternalInventoryHost;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class AEBaseInvBlockEntity
extends AEBaseBlockEntity
implements InternalInventoryHost {
    public AEBaseInvBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        InternalInventory inv = this.getInternalInventory();
        if (inv != InternalInventory.empty()) {
            CompoundTag opt = data.m_128469_("inv");
            for (int x = 0; x < inv.size(); ++x) {
                CompoundTag item = opt.m_128469_("item" + x);
                inv.setItemDirect(x, ItemStack.m_41712_((CompoundTag)item));
            }
        }
    }

    public abstract InternalInventory getInternalInventory();

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        InternalInventory inv = this.getInternalInventory();
        if (inv != InternalInventory.empty()) {
            CompoundTag opt = new CompoundTag();
            for (int x = 0; x < inv.size(); ++x) {
                CompoundTag item = new CompoundTag();
                ItemStack is = inv.getStackInSlot(x);
                if (!is.m_41619_()) {
                    is.m_41739_(item);
                }
                opt.m_128365_("item" + x, (Tag)item);
            }
            data.m_128365_("inv", (Tag)opt);
        }
    }

    @Override
    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        for (ItemStack stack : this.getInternalInventory()) {
            if (GenericStack.isWrapped(stack)) continue;
            drops.add(stack);
        }
    }

    @Override
    public abstract void onChangeInventory(InternalInventory var1, int var2);

    protected InternalInventory getExposedInventoryForSide(Direction side) {
        return this.getInternalInventory();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return LazyOptional.of(this.getInternalInventory()::toItemHandler);
            }
            return LazyOptional.of(() -> this.getExposedInventoryForSide(facing).toItemHandler());
        }
        return super.getCapability(capability, facing);
    }
}

