/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.block.AEBaseBlockItem;
import appeng.core.definitions.AEBlocks;
import appeng.core.localization.Tooltips;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AEBaseBlockItemChargeable
extends AEBaseBlockItem
implements IAEItemPowerStorage {
    public AEBaseBlockItemChargeable(Block block, Item.Properties props) {
        super(block, props);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addCheckedInformation(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        double internalCurrentPower = 0.0;
        double internalMaxPower = this.getMaxEnergyCapacity();
        if (internalMaxPower > 0.0) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                internalCurrentPower = tag.m_128459_("internalCurrentPower");
            }
            lines.add(Tooltips.energyStorageComponent(internalCurrentPower, internalMaxPower));
        }
    }

    @Override
    public double injectAEPower(ItemStack is, double amount, Actionable mode) {
        double internalCurrentPower = this.getInternal(is);
        double internalMaxPower = this.getAEMaxPower(is);
        double required = internalMaxPower - internalCurrentPower;
        double overflow = Math.max(0.0, Math.min(amount - required, amount));
        if (mode == Actionable.MODULATE) {
            double toAdd = Math.min(required, amount);
            double newPowerStored = internalCurrentPower + toAdd;
            this.setInternal(is, newPowerStored);
        }
        return overflow;
    }

    @Override
    public double extractAEPower(ItemStack is, double amount, Actionable mode) {
        double internalCurrentPower = this.getInternal(is);
        double fulfillable = Math.min(amount, internalCurrentPower);
        if (mode == Actionable.MODULATE) {
            double newPowerStored = internalCurrentPower - fulfillable;
            this.setInternal(is, newPowerStored);
        }
        return fulfillable;
    }

    @Override
    public double getAEMaxPower(ItemStack is) {
        return this.getMaxEnergyCapacity();
    }

    @Override
    public double getAECurrentPower(ItemStack is) {
        return this.getInternal(is);
    }

    @Override
    public AccessRestriction getPowerFlow(ItemStack is) {
        return AccessRestriction.WRITE;
    }

    @Override
    public double getChargeRate(ItemStack stack) {
        if (this.m_40614_() == AEBlocks.ENERGY_CELL.block()) {
            return 800.0;
        }
        return 1600.0;
    }

    private double getMaxEnergyCapacity() {
        if (this.m_40614_() == AEBlocks.ENERGY_CELL.block()) {
            return 200000.0;
        }
        return 1600000.0;
    }

    private double getInternal(ItemStack is) {
        CompoundTag nbt = is.m_41784_();
        return nbt.m_128459_("internalCurrentPower");
    }

    private void setInternal(ItemStack is, double amt) {
        CompoundTag nbt = is.m_41784_();
        nbt.m_128347_("internalCurrentPower", amt);
    }
}

