/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.common.tree;

import fr.raksrinana.fallingtree.common.FallingTreeCommon;
import fr.raksrinana.fallingtree.common.config.enums.BreakMode;
import fr.raksrinana.fallingtree.common.tree.BreakTreeResult;
import fr.raksrinana.fallingtree.common.tree.Tree;
import fr.raksrinana.fallingtree.common.tree.breaking.BreakTreeTooBigException;
import fr.raksrinana.fallingtree.common.tree.breaking.ITreeBreakingHandler;
import fr.raksrinana.fallingtree.common.tree.breaking.InstantaneousTreeBreakingHandler;
import fr.raksrinana.fallingtree.common.tree.breaking.ShiftDownTreeBreakingHandler;
import fr.raksrinana.fallingtree.common.tree.builder.TreeTooBigException;
import fr.raksrinana.fallingtree.common.utils.CacheSpeed;
import fr.raksrinana.fallingtree.common.wrapper.IBlockPos;
import fr.raksrinana.fallingtree.common.wrapper.IEnchantment;
import fr.raksrinana.fallingtree.common.wrapper.IItemStack;
import fr.raksrinana.fallingtree.common.wrapper.ILevel;
import fr.raksrinana.fallingtree.common.wrapper.IPlayer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeHandler {
    private static final Logger log = LogManager.getLogger(TreeHandler.class);
    @NotNull
    private final FallingTreeCommon<?> mod;
    private final Map<UUID, CacheSpeed> speedCache = new ConcurrentHashMap<UUID, CacheSpeed>();

    @NotNull
    public Optional<BreakTreeResult> breakTree(@NotNull ILevel level, @NotNull IPlayer player, @NotNull IBlockPos blockPos) {
        if (!level.isServer()) {
            return Optional.empty();
        }
        if (!this.mod.getConfiguration().getTrees().isTreeBreaking()) {
            return Optional.empty();
        }
        if (!this.mod.isPlayerInRightState(player)) {
            return Optional.empty();
        }
        try {
            Optional<Tree> treeOptional = this.mod.getTreeBuilder().getTree(player, level, blockPos);
            if (treeOptional.isEmpty()) {
                return Optional.empty();
            }
            Tree tree = treeOptional.get();
            BreakMode breakMode = this.getBreakMode(player.getMainHandItem());
            boolean result = this.getBreakingHandler(breakMode).breakTree(player, tree);
            return Optional.of(new BreakTreeResult(!result, breakMode));
        }
        catch (TreeTooBigException e) {
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.tree_too_big", this.mod.getConfiguration().getTrees().getMaxScanSize()));
            return Optional.empty();
        }
        catch (BreakTreeTooBigException e) {
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.break_tree_too_big", this.mod.getConfiguration().getTrees().getMaxSize()));
            return Optional.empty();
        }
    }

    @NotNull
    private BreakMode getBreakMode(@NotNull IItemStack itemStack) {
        return itemStack.getAnyEnchant(this.mod.getChopperEnchantments()).flatMap(IEnchantment::getBreakMode).orElseGet(() -> this.mod.getConfiguration().getTrees().getBreakMode());
    }

    @NotNull
    private ITreeBreakingHandler getBreakingHandler(@NotNull BreakMode breakMode) {
        return switch (breakMode) {
            default -> throw new IncompatibleClassChangeError();
            case BreakMode.INSTANTANEOUS -> InstantaneousTreeBreakingHandler.getInstance(this.mod);
            case BreakMode.SHIFT_DOWN -> ShiftDownTreeBreakingHandler.getInstance(this.mod);
        };
    }

    @NotNull
    public Optional<Float> getBreakSpeed(@NotNull IPlayer player, @NotNull IBlockPos blockPos, float originalSpeed) {
        if (!this.mod.getConfiguration().getTrees().isTreeBreaking()) {
            return Optional.empty();
        }
        if (!this.getBreakMode(player.getMainHandItem()).isApplySpeedMultiplier()) {
            return Optional.empty();
        }
        if (!this.mod.isPlayerInRightState(player)) {
            return Optional.empty();
        }
        CacheSpeed cacheSpeed = this.speedCache.compute(player.getUUID(), (uuid, speed) -> {
            if (Objects.isNull(speed) || !speed.isValid(blockPos)) {
                speed = this.getSpeed(player, blockPos, originalSpeed);
            }
            return speed;
        });
        return Optional.ofNullable(cacheSpeed).map(CacheSpeed::getSpeed);
    }

    @Nullable
    private CacheSpeed getSpeed(@NotNull IPlayer player, @NotNull IBlockPos pos, float originalSpeed) {
        double speedMultiplicand = this.mod.getConfiguration().getTools().getSpeedMultiplicand();
        try {
            return speedMultiplicand <= 0.0 ? null : (CacheSpeed)this.mod.getTreeBuilder().getTree(player, player.getLevel(), pos).map(tree -> new CacheSpeed(pos, originalSpeed / ((float)speedMultiplicand * (float)tree.getLogCount()))).orElse(null);
        }
        catch (TreeTooBigException e) {
            return null;
        }
    }

    public TreeHandler(@NotNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

