/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.client;

import com.github.kay9.dragonmounts.accessors.ModelPartAccess;
import com.github.kay9.dragonmounts.client.DragonAnimator;
import com.github.kay9.dragonmounts.client.ModelPartProxy;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class DragonModel
extends EntityModel<TameableDragon> {
    public static final int NECK_SIZE = 10;
    public static final int TAIL_SIZE = 10;
    public static final int VERTS_NECK = 7;
    public static final int VERTS_TAIL = 12;
    public static final int HEAD_OFS = -16;
    public final ModelPart head;
    public final ModelPart neck;
    public final ModelPart neckScale;
    public final ModelPart tail;
    public final ModelPart tailHornLeft;
    public final ModelPart tailHornRight;
    public final ModelPart tailScaleLeft;
    public final ModelPart tailScaleMiddle;
    public final ModelPart tailScaleRight;
    public final ModelPart jaw;
    public final ModelPart body;
    public final ModelPart back;
    public final ModelPart forethigh;
    public final ModelPart forecrus;
    public final ModelPart forefoot;
    public final ModelPart foretoe;
    public final ModelPart hindthigh;
    public final ModelPart hindcrus;
    public final ModelPart hindfoot;
    public final ModelPart hindtoe;
    public final ModelPartProxy thinForeThigh;
    public final ModelPartProxy thinHindThigh;
    public final ModelPart wingArm;
    public final ModelPart wingForearm;
    public final ModelPart[] wingFinger = new ModelPart[4];
    public final ModelPartProxy[] neckProxy = new ModelPartProxy[7];
    public final ModelPartProxy[] tailProxy = new ModelPartProxy[12];
    public final ModelPartProxy[] thighProxy = new ModelPartProxy[4];
    public float size;
    private boolean thinLegs;
    private static final Matrix4f INVERSE_SCALE = Matrix4f.m_27632_((float)-1.0f, (float)1.0f, (float)1.0f);
    private static final Matrix3f INVERSE_NORMS = new Matrix3f(INVERSE_SCALE);

    public DragonModel(ModelPart root) {
        int i;
        this.body = root.m_171324_("body");
        this.back = this.body.m_171324_("back");
        this.neck = root.m_171324_("neck");
        this.neckScale = this.neck.m_171324_("neck_scale");
        this.head = root.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.tail = root.m_171324_("tail");
        this.tailScaleLeft = this.tail.m_171324_("left_tail_scale");
        this.tailScaleMiddle = this.tail.m_171324_("middle_tail_scale");
        this.tailScaleRight = this.tail.m_171324_("right_tail_scale");
        this.tailHornRight = this.tail.m_171324_("right_tail_spike");
        this.tailHornLeft = this.tail.m_171324_("left_tail_spike");
        this.wingArm = root.m_171324_("wing_arm");
        this.wingForearm = this.wingArm.m_171324_("wing_forearm");
        this.forethigh = root.m_171324_("fore_thigh");
        this.forecrus = this.forethigh.m_171324_("fore_crus");
        this.forefoot = this.forecrus.m_171324_("fore_foot");
        this.foretoe = this.forefoot.m_171324_("fore_toe");
        this.hindthigh = root.m_171324_("hind_thigh");
        this.hindcrus = this.hindthigh.m_171324_("hind_crus");
        this.hindfoot = this.hindcrus.m_171324_("hind_foot");
        this.hindtoe = this.hindfoot.m_171324_("hind_toe");
        this.thinForeThigh = new ModelPartProxy(root.m_171324_("thin_fore_thigh"));
        this.thinHindThigh = new ModelPartProxy(root.m_171324_("thin_hind_thigh"));
        for (i = 1; i < 5; ++i) {
            this.wingFinger[i - 1] = this.wingForearm.m_171324_("wing_finger_" + i);
        }
        for (i = 0; i < this.neckProxy.length; ++i) {
            this.neckProxy[i] = new ModelPartProxy(this.neck);
        }
        for (i = 0; i < this.tailProxy.length; ++i) {
            this.tailProxy[i] = new ModelPartProxy(this.tail);
        }
        for (i = 0; i < 4; ++i) {
            this.thighProxy[i] = new ModelPartProxy(i % 2 == 0 ? this.forethigh : this.hindthigh);
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        DragonModel.buildBody(root);
        DragonModel.buildNeck(root);
        DragonModel.buildHead(root);
        DragonModel.buildTail(root);
        DragonModel.buildWing(root);
        DragonModel.buildLegs(root);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)256, (int)256);
    }

    private static void buildBody(PartDefinition root) {
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-12.0f, 0.0f, -16.0f, 24.0f, 24.0f, 64.0f).m_171514_(0, 32).m_171481_(-1.0f, -6.0f, 10.0f, 2.0f, 6.0f, 12.0f).m_171481_(-1.0f, -6.0f, 30.0f, 2.0f, 6.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)8.0f));
        body.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-1.0f, -6.0f, -10.0f, 2.0f, 6.0f, 12.0f), PartPose.f_171404_);
    }

    private static void buildNeck(PartDefinition root) {
        PartDefinition neck = root.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(112, 88).m_171481_(-5.0f, -5.0f, -5.0f, 10.0f, 10.0f, 10.0f), PartPose.f_171404_);
        neck.m_171599_("neck_scale", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -7.0f, -3.0f, 2.0f, 4.0f, 6.0f), PartPose.f_171404_);
    }

    private static void buildHead(PartDefinition root) {
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(56, 88).m_171481_(-6.0f, -1.0f, -24.0f, 12.0f, 5.0f, 16.0f).m_171514_(0, 0).m_171481_(-8.0f, -8.0f, -10.0f, 16.0f, 16.0f, 16.0f).m_171514_(48, 0).m_171481_(-5.0f, -3.0f, -22.0f, 2.0f, 2.0f, 4.0f).m_171480_().m_171481_(3.0f, -3.0f, -22.0f, 2.0f, 2.0f, 4.0f), PartPose.f_171404_);
        DragonModel.addHorns(head);
        head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 88).m_171481_(-6.0f, 0.0f, -16.0f, 12.0f, 4.0f, 16.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-8.0f));
    }

    private static void addHorns(PartDefinition head) {
        int hornThick = 3;
        int hornLength = 12;
        float hornOfs = -((float)hornThick / 2.0f);
        float hornPosX = -5.0f;
        float hornPosY = -8.0f;
        float hornPosZ = 0.0f;
        float hornRotX = 0.523599f;
        float hornRotY = -0.523599f;
        float hornRotZ = 0.0f;
        head.m_171599_("horn1", CubeListBuilder.m_171558_().m_171514_(28, 32).m_171481_(hornOfs, hornOfs, hornOfs, (float)hornThick, (float)hornThick, (float)hornLength), PartPose.m_171423_((float)hornPosX, (float)hornPosY, (float)hornPosZ, (float)hornRotX, (float)hornRotY, (float)hornRotZ));
        head.m_171599_("horn2", CubeListBuilder.m_171558_().m_171514_(28, 32).m_171480_().m_171481_(hornOfs, hornOfs, hornOfs, (float)hornThick, (float)hornThick, (float)hornLength), PartPose.m_171423_((float)(hornPosX * -1.0f), (float)hornPosY, (float)hornPosZ, (float)hornRotX, (float)(hornRotY * -1.0f), (float)hornRotZ));
    }

    private static void buildTail(PartDefinition root) {
        PartDefinition tail = root.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(152, 88).m_171481_(-5.0f, -5.0f, -5.0f, 10.0f, 10.0f, 10.0f), PartPose.f_171404_);
        CubeListBuilder tailSpikeCube = CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -8.0f, -3.0f, 2.0f, 4.0f, 6.0f);
        tail.m_171599_("left_tail_scale", tailSpikeCube, PartPose.m_171430_((float)0.0f, (float)0.0f, (float)0.785398f));
        tail.m_171599_("middle_tail_scale", tailSpikeCube, PartPose.f_171404_);
        tail.m_171599_("right_tail_scale", tailSpikeCube, PartPose.m_171430_((float)0.0f, (float)0.0f, (float)-0.785398f));
        DragonModel.addTailSpikes(tail);
    }

    private static void addTailSpikes(PartDefinition tail) {
        int hornThick = 3;
        int hornLength = 32;
        float hornOfs = -((float)hornThick / 2.0f);
        float hornPosX = 0.0f;
        float hornPosY = hornOfs;
        float hornPosZ = 5.0f;
        float hornRotX = -0.261799f;
        float hornRotY = -2.53073f;
        float hornRotZ = 0.0f;
        tail.m_171599_("right_tail_spike", CubeListBuilder.m_171558_().m_171514_(0, 117).m_171481_(hornOfs, hornOfs, hornOfs, (float)hornThick, (float)hornThick, (float)hornLength), PartPose.m_171423_((float)hornPosX, (float)hornPosY, (float)hornPosZ, (float)hornRotX, (float)hornRotY, (float)hornRotZ));
        tail.m_171599_("left_tail_spike", CubeListBuilder.m_171558_().m_171514_(0, 117).m_171480_().m_171481_(hornOfs, hornOfs, hornOfs, (float)hornThick, (float)hornThick, (float)hornLength), PartPose.m_171423_((float)(hornPosX * -1.0f), (float)hornPosY, (float)hornPosZ, (float)hornRotX, (float)(hornRotY * -1.0f), (float)hornRotZ));
    }

    private static void buildWing(PartDefinition root) {
        PartDefinition wingArm = root.m_171599_("wing_arm", CubeListBuilder.m_171558_().m_171514_(0, 152).m_171481_(-28.0f, -3.0f, -3.0f, 28.0f, 6.0f, 6.0f).m_171514_(116, 232).m_171481_(-28.0f, 0.0f, 2.0f, 28.0f, 0.01f, 24.0f), PartPose.m_171419_((float)-10.0f, (float)5.0f, (float)4.0f));
        PartDefinition wingForearm = wingArm.m_171599_("wing_forearm", CubeListBuilder.m_171558_().m_171514_(0, 164).m_171481_(-48.0f, -2.0f, -2.0f, 48.0f, 4.0f, 4.0f), PartPose.m_171419_((float)-28.0f, (float)0.0f, (float)0.0f));
        CubeListBuilder shortSkins = CubeListBuilder.m_171558_().m_171514_(0, 172).m_171481_(-70.0f, -1.0f, -1.0f, 70.0f, 2.0f, 2.0f).m_171514_(-49, 176).m_171481_(-70.0f, 0.0f, 1.0f, 70.0f, 0.01f, 48.0f);
        PartPose shortSkinsPos = PartPose.m_171419_((float)-47.0f, (float)0.0f, (float)0.0f);
        for (int i = 1; i < 4; ++i) {
            wingForearm.m_171599_("wing_finger_" + i, shortSkins, shortSkinsPos);
        }
        wingForearm.m_171599_("wing_finger_4", CubeListBuilder.m_171558_().m_171514_(0, 172).m_171481_(-70.0f, -1.0f, -1.0f, 70.0f, 2.0f, 2.0f).m_171514_(-32, 224).m_171481_(-70.0f, 0.0f, 1.0f, 70.0f, 0.01f, 32.0f), shortSkinsPos);
    }

    private static void buildLegs(PartDefinition root) {
        DragonModel.buildLeg(root, false, false);
        DragonModel.buildLeg(root, true, false);
        DragonModel.buildLeg(root, false, true);
        DragonModel.buildLeg(root, true, true);
    }

    private static void buildLeg(PartDefinition root, boolean hind, boolean thin) {
        Object baseName;
        float baseLength = 26.0f;
        Object object = baseName = hind ? "hind_" : "fore_";
        if (thin) {
            baseName = "thin_" + (String)baseName;
        }
        float thighPosX = -11.0f;
        float thighPosY = 18.0f;
        float thighPosZ = 4.0f;
        int thighThick = 9 - (thin ? 2 : 0);
        int thighLength = (int)(baseLength * (hind ? 0.9f : 0.77f));
        if (hind) {
            ++thighThick;
            thighPosY -= 5.0f;
        }
        float thighOfs = -((float)thighThick / 2.0f);
        PartDefinition thigh = root.m_171599_((String)baseName + "thigh", CubeListBuilder.m_171558_().m_171514_(112, hind ? 29 : 0).m_171481_(thighOfs, thighOfs, thighOfs, (float)thighThick, (float)thighLength, (float)thighThick), PartPose.m_171419_((float)thighPosX, (float)thighPosY, (float)thighPosZ));
        float crusPosX = 0.0f;
        float crusPosY = (float)thighLength + thighOfs;
        float crusPosZ = 0.0f;
        int crusThick = thighThick - 2;
        int crusLength = (int)(baseLength * (hind ? 0.7f : 0.8f));
        if (hind) {
            --crusThick;
            crusLength -= 2;
        }
        float crusOfs = -((float)crusThick / 2.0f);
        PartDefinition crus = thigh.m_171599_((String)baseName + "crus", CubeListBuilder.m_171558_().m_171514_(hind ? 152 : 148, hind ? 29 : 0).m_171481_(crusOfs, crusOfs, crusOfs, (float)crusThick, (float)crusLength, (float)crusThick), PartPose.m_171419_((float)crusPosX, (float)crusPosY, (float)crusPosZ));
        float footPosX = 0.0f;
        float footPosY = (float)crusLength + crusOfs / 2.0f;
        float footPosZ = 0.0f;
        int footWidth = crusThick + 2 + (thin ? 2 : 0);
        int footHeight = 4;
        int footLength = (int)(baseLength * (hind ? 0.67f : 0.34f));
        float footOfsX = -((float)footWidth / 2.0f);
        float footOfsY = -((float)footHeight / 2.0f);
        float footOfsZ = (float)footLength * -0.75f;
        PartDefinition foot = crus.m_171599_((String)baseName + "foot", CubeListBuilder.m_171558_().m_171514_(hind ? 180 : 210, hind ? 29 : 0).m_171481_(footOfsX, footOfsY, footOfsZ, (float)footWidth, (float)footHeight, (float)footLength), PartPose.m_171419_((float)footPosX, (float)footPosY, (float)footPosZ));
        int toeWidth = footWidth;
        int toeHeight = footHeight;
        int toeLength = (int)(baseLength * (hind ? 0.27f : 0.33f));
        float toePosX = 0.0f;
        float toePosY = 0.0f;
        float toePosZ = footOfsZ - footOfsY / 2.0f;
        float toeOfsX = -((float)toeWidth / 2.0f);
        float toeOfsY = -((float)toeHeight / 2.0f);
        float toeOfsZ = -toeLength;
        foot.m_171599_((String)baseName + "toe", CubeListBuilder.m_171558_().m_171514_(hind ? 215 : 176, hind ? 29 : 0).m_171481_(toeOfsX, toeOfsY, toeOfsZ, (float)toeWidth, (float)toeHeight, (float)toeLength), PartPose.m_171419_((float)toePosX, (float)toePosY, (float)toePosZ));
    }

    public void prepareMobModel(TameableDragon dragon, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        boolean middleScales;
        DragonBreed.ModelProperties props = dragon.getBreed().modelProperties();
        this.tailScaleMiddle.f_104207_ = middleScales = props.middleTailScales();
        this.tailScaleLeft.f_104207_ = !middleScales;
        this.tailScaleRight.f_104207_ = this.tailScaleLeft.f_104207_;
        this.size = Math.min(dragon.m_6134_(), 1.0f);
        this.thinLegs = props.thinLegs();
        dragon.getAnimator().setPartialTicks(pPartialTick);
    }

    public void setupAnim(TameableDragon dragon, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        DragonAnimator animator = dragon.getAnimator();
        animator.setLook(pNetHeadYaw, pHeadPitch);
        animator.setMovement(pLimbSwing, pLimbSwingAmount * dragon.m_6134_());
        dragon.getAnimator().animate(this);
    }

    public void m_7695_(PoseStack ps, VertexConsumer vertices, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        this.body.m_104306_(ps, vertices, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        this.renderHead(ps, vertices, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        for (ModelPartProxy proxy : this.neckProxy) {
            proxy.render(ps, vertices, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        }
        for (ModelPartProxy proxy : this.tailProxy) {
            proxy.render(ps, vertices, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        }
        this.renderWings(ps, vertices, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        this.renderLegs(ps, vertices, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
    }

    protected void renderHead(PoseStack ps, VertexConsumer vertices, int packedLight, int packedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        float headScale = 1.4f / (this.size + 0.5f);
        ((ModelPartAccess)this.head).setRenderScale(headScale, headScale, headScale);
        this.head.m_104306_(ps, vertices, packedLight, packedOverlay, pRed, pGreen, pBlue, pAlpha);
    }

    public void renderWings(PoseStack ps, VertexConsumer vertices, int packedLight, int packedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        ps.m_85836_();
        ps.m_85841_(1.1f, 1.1f, 1.1f);
        this.wingArm.m_104306_(ps, vertices, packedLight, packedOverlay, pRed, pGreen, pBlue, pAlpha);
        ps.m_85850_().m_85861_().m_27644_(INVERSE_SCALE);
        ps.m_85850_().m_85864_().m_8178_(INVERSE_NORMS);
        this.wingArm.m_104306_(ps, vertices, packedLight, packedOverlay, pRed, pGreen, pBlue, pAlpha);
        ps.m_85849_();
    }

    protected void renderLegs(PoseStack ps, VertexConsumer vertices, int packedLight, int packedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        ps.m_85836_();
        for (int i = 0; i < this.thighProxy.length; ++i) {
            ModelPartProxy proxy = this.thighProxy[i];
            if (this.thinLegs) {
                ModelPartProxy thin = i % 2 == 0 ? this.thinForeThigh : this.thinHindThigh;
                proxy.copy(thin);
                proxy = thin;
            }
            proxy.render(ps, vertices, packedLight, packedOverlay, pRed, pGreen, pBlue, pAlpha);
            if (i != 1) continue;
            ps.m_85850_().m_85861_().m_27644_(INVERSE_SCALE);
            ps.m_85850_().m_85864_().m_8178_(INVERSE_NORMS);
        }
        ps.m_85849_();
    }
}

