/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.client.DragonEggRenderer;
import com.github.kay9.dragonmounts.client.DragonModel;
import com.github.kay9.dragonmounts.client.DragonRenderer;
import com.github.kay9.dragonmounts.client.EggEntityRenderer;
import com.github.kay9.dragonmounts.client.Keybinds;
import com.github.kay9.dragonmounts.client.MountControlsMessenger;
import com.github.kay9.dragonmounts.dragon.DMLEggBlock;
import com.github.kay9.dragonmounts.dragon.DragonSpawnEgg;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.searchtree.MutableSearchTree;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dragonmounts")
public class DragonMountsLegacy {
    public static final String MOD_ID = "dragonmounts";
    public static final Logger LOG = LogManager.getLogger();
    public static final SimpleChannel NETWORK;

    public DragonMountsLegacy() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DMLRegistry.init(bus);
        BreedRegistry.DEFERRED_REGISTRY.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DMLConfig.COMMON);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)DMLConfig.SERVER);
        DragonMountsLegacy.setupEvents();
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    private static void setupEvents() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.addListener(DragonMountsLegacy::attemptVanillaEggReplacement);
        bus.addListener(e -> e.put((EntityType)DMLRegistry.DRAGON.get(), TameableDragon.createAttributes().m_22265_()));
        if (FMLLoader.getDist() == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(DragonMountsLegacy::cameraAngles);
            MinecraftForge.EVENT_BUS.addListener(Keybinds::handleKeyPress);
            MinecraftForge.EVENT_BUS.addListener(MountControlsMessenger::tick);
            MinecraftForge.EVENT_BUS.addListener(DragonMountsLegacy::populateSearchTrees);
            bus.addListener(DragonMountsLegacy::defineBlockModels);
            bus.addListener(e -> e.getItemColors().m_92689_(DragonSpawnEgg::getColor, new ItemLike[]{(ItemLike)DMLRegistry.SPAWN_EGG.get()}));
            bus.addListener(DragonMountsLegacy::rendererRegistry);
        }
    }

    private static void attemptVanillaEggReplacement(PlayerInteractEvent.RightClickBlock evt) {
        if (DMLEggBlock.overrideVanillaDragonEgg(evt.getWorld(), evt.getPos(), evt.getPlayer())) {
            evt.setCanceled(true);
        }
    }

    private static void defineBlockModels(ModelRegistryEvent evt) {
        String dir = "models/block/dragon_eggs";
        int length = "models/".length();
        int suffixLength = ".json".length();
        for (ResourceLocation rl : Minecraft.m_91087_().m_91098_().m_6540_(dir, f -> f.endsWith(".json"))) {
            String path = rl.m_135815_();
            path = path.substring(length, path.length() - suffixLength);
            ResourceLocation model = new ResourceLocation(rl.m_135827_(), path);
            String id = path.substring("block/dragon_eggs/".length(), path.length() - "_dragon_egg".length());
            ForgeModelBakery.addSpecialModel((ResourceLocation)model);
            DragonEggRenderer.MODEL_CACHE.put(new ResourceLocation(rl.m_135827_(), id), model);
        }
    }

    private static void rendererRegistry(EntityRenderersEvent.RegisterRenderers e) {
        e.registerEntityRenderer((EntityType)DMLRegistry.DRAGON.get(), DragonRenderer::new);
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)DragonRenderer.LAYER_LOCATION, DragonModel::createBodyLayer);
        e.registerEntityRenderer((EntityType)DMLRegistry.DRAGON_EGG.get(), EggEntityRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)DMLRegistry.EGG_BLOCK_ENTITY.get(), DragonEggRenderer::instance);
    }

    private static void cameraAngles(EntityViewRenderEvent.CameraSetup evt) {
        if (Minecraft.m_91087_().f_91074_.m_20202_() instanceof TameableDragon) {
            Camera camera = evt.getCamera();
            int distance = 0;
            int vertical = 0;
            switch (Minecraft.m_91087_().f_91066_.m_92176_()) {
                case THIRD_PERSON_FRONT: {
                    distance = 6;
                    break;
                }
                case THIRD_PERSON_BACK: {
                    distance = 6;
                    vertical = 4;
                }
            }
            camera.m_90568_(-camera.m_90566_((double)distance), (double)vertical, 0.0);
        }
    }

    private static void populateSearchTrees(TagsUpdatedEvent evt) {
        MutableSearchTree tree = Minecraft.m_91087_().m_91171_(SearchRegistry.f_119941_);
        List oldContents = tree.m_6293_("dragonmounts:");
        NonNullList newContents = NonNullList.m_122779_();
        ((Item)DMLRegistry.EGG_BLOCK_ITEM.get()).m_6787_(CreativeModeTab.f_40754_, newContents);
        ((Item)DMLRegistry.SPAWN_EGG.get()).m_6787_(CreativeModeTab.f_40754_, newContents);
        block0: for (ItemStack newItem : newContents) {
            for (ItemStack oldItem : oldContents) {
                if (!ItemStack.m_41728_((ItemStack)newItem, (ItemStack)oldItem)) continue;
                continue block0;
            }
            tree.m_8080_((Object)newItem);
        }
        tree.m_7729_();
    }

    static {
        String PROTOCOL_VERSION = "1.O";
        NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)DragonMountsLegacy.id("network")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

