/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class EdDoubleGateBlock
extends StandardBlocks.HorizontalWaterLoggable {
    public static final IntegerProperty SEGMENT = IntegerProperty.m_61631_((String)"segment", (int)0, (int)1);
    public static final BooleanProperty OPEN = FenceGateBlock.f_53341_;
    public static final int SEGMENT_LOWER = 0;
    public static final int SEGMENT_UPPER = 1;
    protected final ArrayList<VoxelShape> collision_shapes_;

    public EdDoubleGateBlock(long config, BlockBehaviour.Properties properties, AABB aabb) {
        this(config, properties, new AABB[]{aabb});
    }

    public EdDoubleGateBlock(long config, BlockBehaviour.Properties properties, AABB[] aabbs) {
        super(config, properties, aabbs);
        AABB[] caabbs = new AABB[aabbs.length];
        for (int i = 0; i < caabbs.length; ++i) {
            caabbs[i] = aabbs[i].m_82363_(0.0, 0.5, 0.0);
        }
        this.collision_shapes_ = new ArrayList<VoxelShape>(Arrays.asList(Shapes.m_83144_(), Shapes.m_83144_(), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(caabbs, Direction.NORTH, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(caabbs, Direction.SOUTH, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(caabbs, Direction.WEST, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(caabbs, Direction.EAST, true)), Shapes.m_83144_(), Shapes.m_83144_()));
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return (Boolean)state.m_61143_((Property)OPEN) != false ? Shapes.m_83040_() : this.collision_shapes_.get(((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122411_() & 7);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SEGMENT}).m_61104_(new Property[]{OPEN});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getInitialState(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return this.getInitialState(super.m_7417_(state, facing, facingState, world, pos, facingPos), world, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (rayTraceResult.m_82434_() == Direction.UP || rayTraceResult.m_82434_() == Direction.DOWN && player.m_21120_(hand).m_41720_() == this.m_5456_()) {
            return InteractionResult.PASS;
        }
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        boolean open = (Boolean)state.m_61143_((Property)OPEN) == false;
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 26);
        if ((Integer)state.m_61143_((Property)SEGMENT) == 1) {
            BlockState adjacent = world.m_8055_(pos.m_7495_());
            if (adjacent.m_60734_() == this) {
                world.m_7731_(pos.m_7495_(), (BlockState)adjacent.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 26);
            }
        } else {
            BlockState adjacent = world.m_8055_(pos.m_7494_());
            if (adjacent.m_60734_() == this) {
                world.m_7731_(pos.m_7494_(), (BlockState)adjacent.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 26);
            }
        }
        world.m_5594_(null, pos, open ? SoundEvents.f_12056_ : SoundEvents.f_12055_, SoundSource.BLOCKS, 0.7f, 1.4f);
        return InteractionResult.CONSUME;
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockState adjacent;
        BlockPos adjacent_pos;
        if (world.f_46443_) {
            return;
        }
        boolean powered = false;
        if ((Integer)state.m_61143_((Property)SEGMENT) == 1) {
            adjacent_pos = pos.m_7495_();
            adjacent = world.m_8055_(adjacent_pos);
            if (adjacent.m_60734_() != this) {
                adjacent = null;
            }
            if (world.m_46681_(pos.m_7494_(), Direction.UP) > 0) {
                powered = true;
            } else if (adjacent != null && world.m_46753_(pos.m_6625_(2))) {
                powered = true;
            }
        } else {
            adjacent_pos = pos.m_7494_();
            adjacent = world.m_8055_(adjacent_pos);
            if (adjacent.m_60734_() != this) {
                adjacent = null;
            }
            if (world.m_46753_(pos)) {
                powered = true;
            } else if (adjacent != null && world.m_46681_(pos.m_6630_(2), Direction.UP) > 0) {
                powered = true;
            }
        }
        boolean sound = false;
        if (powered != (Boolean)state.m_61143_((Property)OPEN)) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(powered)), 26);
            sound = true;
        }
        if (adjacent != null && powered != (Boolean)adjacent.m_61143_((Property)OPEN)) {
            world.m_7731_(adjacent_pos, (BlockState)adjacent.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(powered)), 26);
            sound = true;
        }
        if (sound) {
            world.m_5594_(null, pos, powered ? SoundEvents.f_12056_ : SoundEvents.f_12055_, SoundSource.BLOCKS, 0.7f, 1.4f);
        }
    }

    private BlockState getInitialState(BlockState state, LevelAccessor world, BlockPos pos) {
        BlockState down = world.m_8055_(pos.m_7495_());
        if (down.m_60734_() == this) {
            return (BlockState)((BlockState)((BlockState)state.m_61124_((Property)SEGMENT, (Comparable)Integer.valueOf(1))).m_61124_((Property)OPEN, (Comparable)((Boolean)down.m_61143_((Property)OPEN)))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)((Direction)down.m_61143_((Property)HORIZONTAL_FACING)));
        }
        BlockState up = world.m_8055_(pos.m_7494_());
        if (up.m_60734_() == this) {
            return (BlockState)((BlockState)((BlockState)state.m_61124_((Property)SEGMENT, (Comparable)Integer.valueOf(0))).m_61124_((Property)OPEN, (Comparable)((Boolean)up.m_61143_((Property)OPEN)))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)((Direction)up.m_61143_((Property)HORIZONTAL_FACING)));
        }
        return (BlockState)((BlockState)state.m_61124_((Property)SEGMENT, (Comparable)Integer.valueOf(0))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false));
    }
}

