/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.block.ITileBound;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.advancements.LokiPlaceTrigger;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.ItemRelicBauble;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ItemLokiRing
extends ItemRelicBauble
implements IWireframeCoordinateListProvider {
    private static final String TAG_CURSOR_LIST = "cursorList";
    private static final String TAG_CURSOR_PREFIX = "cursor";
    private static final String TAG_CURSOR_COUNT = "cursorCount";
    private static final String TAG_X_OFFSET = "xOffset";
    private static final String TAG_Y_OFFSET = "yOffset";
    private static final String TAG_Z_OFFSET = "zOffset";
    private static final String TAG_X_ORIGIN = "xOrigin";
    private static final String TAG_Y_ORIGIN = "yOrigin";
    private static final String TAG_Z_ORIGIN = "zOrigin";
    private static boolean recCall = false;

    public ItemLokiRing(Item.Properties props) {
        super(props);
    }

    public static InteractionResult onPlayerInteract(Player player, Level world, InteractionHand hand, BlockHitResult lookPos) {
        ItemStack lokiRing = ItemLokiRing.getLokiRing(player);
        if (lokiRing.m_41619_() || !player.m_6144_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        List<BlockPos> cursors = ItemLokiRing.getCursorList(lokiRing);
        if (lookPos.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        BlockPos hit = lookPos.m_82425_();
        if (stack.m_41619_() && hand == InteractionHand.MAIN_HAND) {
            BlockPos originCoords = ItemLokiRing.getBindingCenter(lokiRing);
            if (!world.f_46443_) {
                if (originCoords.m_123342_() == Integer.MIN_VALUE) {
                    ItemLokiRing.setBindingCenter(lokiRing, hit);
                    ItemLokiRing.setCursorList(lokiRing, null);
                } else if (originCoords.equals((Object)hit)) {
                    ItemLokiRing.exitBindingMode(lokiRing);
                } else {
                    BlockPos relPos = hit.m_141950_((Vec3i)originCoords);
                    boolean removed = cursors.remove(relPos);
                    if (!removed) {
                        cursors.add(relPos);
                    }
                    ItemLokiRing.setCursorList(lokiRing, cursors);
                }
            }
            return InteractionResult.SUCCESS;
        }
        int cost = Math.min(cursors.size(), (int)Math.pow(Math.E, (double)cursors.size() * 0.25));
        ItemStack original = stack.m_41777_();
        int successes = 0;
        for (BlockPos cursor : cursors) {
            BlockPos pos = hit.m_141952_((Vec3i)cursor);
            if (!ManaItemHandler.instance().requestManaExact(lokiRing, player, cost, false)) break;
            Vec3 lookHit = lookPos.m_82450_();
            Vec3 newHitVec = new Vec3((double)pos.m_123341_() + Mth.m_14185_((double)lookHit.m_7096_()), (double)pos.m_123342_() + Mth.m_14185_((double)lookHit.m_7098_()), (double)pos.m_123343_() + Mth.m_14185_((double)lookHit.m_7094_()));
            BlockHitResult newHit = new BlockHitResult(newHitVec, lookPos.m_82434_(), pos, false);
            UseOnContext ctx = new UseOnContext(player, hand, newHit);
            InteractionResult result = player.m_7500_() ? PlayerHelper.substituteUse(ctx, original.m_41777_()) : stack.m_41661_(ctx);
            if (!result.m_19077_()) continue;
            ManaItemHandler.instance().requestManaExact(lokiRing, player, cost, true);
            ++successes;
        }
        if (successes > 0 && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LokiPlaceTrigger.INSTANCE.trigger(serverPlayer, lokiRing, successes);
        }
        return successes > 0 ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void breakOnAllCursors(Player player, ItemStack stack, BlockPos pos, Direction side) {
        Item item = stack.m_41720_();
        ItemStack lokiRing = ItemLokiRing.getLokiRing(player);
        if (lokiRing.m_41619_() || player.f_19853_.f_46443_ || !(item instanceof ISequentialBreaker)) {
            return;
        }
        ISequentialBreaker breaker = (ISequentialBreaker)item;
        if (recCall) {
            return;
        }
        recCall = true;
        List<BlockPos> cursors = ItemLokiRing.getCursorList(lokiRing);
        try {
            for (BlockPos offset : cursors) {
                BlockPos coords = pos.m_141952_((Vec3i)offset);
                BlockState state = player.f_19853_.m_8055_(coords);
                breaker.breakOtherBlock(player, stack, coords, pos, side);
                ToolCommons.removeBlockWithDrops(player, stack, player.f_19853_, coords, s -> s.m_60713_(state.m_60734_()) && s.m_60767_() == state.m_60767_());
            }
        }
        finally {
            recCall = false;
        }
    }

    @Override
    public void onUnequipped(ItemStack stack, LivingEntity living) {
        ItemLokiRing.setCursorList(stack, null);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean held) {
        super.m_6883_(stack, world, entity, slot, held);
        if (slot >= 0) {
            ItemLokiRing.exitBindingMode(stack);
        }
    }

    @Override
    public List<BlockPos> getWireframesToDraw(Player player, ItemStack stack) {
        if (ItemLokiRing.getLokiRing(player) != stack) {
            return ImmutableList.of();
        }
        HitResult lookPos = Minecraft.m_91087_().f_91077_;
        if (lookPos != null && lookPos.m_6662_() == HitResult.Type.BLOCK && !player.f_19853_.m_46859_(((BlockHitResult)lookPos).m_82425_())) {
            List<BlockPos> list = ItemLokiRing.getCursorList(stack);
            BlockPos origin = ItemLokiRing.getBindingCenter(stack);
            for (int i = 0; i < list.size(); ++i) {
                if (origin.m_123342_() != Integer.MIN_VALUE) {
                    list.set(i, list.get(i).m_141952_((Vec3i)origin));
                    continue;
                }
                list.set(i, list.get(i).m_141952_((Vec3i)((BlockHitResult)lookPos).m_82425_()));
            }
            return list;
        }
        return ImmutableList.of();
    }

    @Override
    public BlockPos getSourceWireframe(Player player, ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        if (ItemLokiRing.getLokiRing(player) == stack) {
            BlockPos currentBuildCenter = ItemLokiRing.getBindingCenter(stack);
            if (currentBuildCenter.m_123342_() != Integer.MIN_VALUE) {
                return currentBuildCenter;
            }
            if (mc.f_91077_ instanceof BlockHitResult && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK && !ItemLokiRing.getCursorList(stack).isEmpty()) {
                return ((BlockHitResult)mc.f_91077_).m_82425_();
            }
        }
        return null;
    }

    private static ItemStack getLokiRing(Player player) {
        return EquipmentHandler.findOrEmpty(ModItems.lokiRing, (LivingEntity)player);
    }

    private static BlockPos getBindingCenter(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_X_ORIGIN, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_Y_ORIGIN, Integer.MIN_VALUE);
        int z = ItemNBTHelper.getInt(stack, TAG_Z_ORIGIN, 0);
        return new BlockPos(x, y, z);
    }

    private static void exitBindingMode(ItemStack stack) {
        ItemLokiRing.setBindingCenter(stack, ITileBound.UNBOUND_POS);
    }

    private static void setBindingCenter(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.setInt(stack, TAG_X_ORIGIN, pos.m_123341_());
        ItemNBTHelper.setInt(stack, TAG_Y_ORIGIN, pos.m_123342_());
        ItemNBTHelper.setInt(stack, TAG_Z_ORIGIN, pos.m_123343_());
    }

    private static List<BlockPos> getCursorList(ItemStack stack) {
        CompoundTag cmp = ItemNBTHelper.getCompound(stack, TAG_CURSOR_LIST, false);
        ArrayList<BlockPos> cursors = new ArrayList<BlockPos>();
        int count = cmp.m_128451_(TAG_CURSOR_COUNT);
        for (int i = 0; i < count; ++i) {
            CompoundTag cursorCmp = cmp.m_128469_(TAG_CURSOR_PREFIX + i);
            int x = cursorCmp.m_128451_(TAG_X_OFFSET);
            int y = cursorCmp.m_128451_(TAG_Y_OFFSET);
            int z = cursorCmp.m_128451_(TAG_Z_OFFSET);
            cursors.add(new BlockPos(x, y, z));
        }
        return cursors;
    }

    private static void setCursorList(ItemStack stack, @Nullable List<BlockPos> cursors) {
        CompoundTag cmp = new CompoundTag();
        if (cursors != null) {
            int i = 0;
            for (BlockPos cursor : cursors) {
                CompoundTag cursorCmp = ItemLokiRing.cursorToCmp(cursor);
                cmp.m_128365_(TAG_CURSOR_PREFIX + i, (Tag)cursorCmp);
                ++i;
            }
            cmp.m_128405_(TAG_CURSOR_COUNT, i);
        }
        ItemNBTHelper.setCompound(stack, TAG_CURSOR_LIST, cmp);
    }

    private static CompoundTag cursorToCmp(BlockPos pos) {
        CompoundTag cmp = new CompoundTag();
        cmp.m_128405_(TAG_X_OFFSET, pos.m_123341_());
        cmp.m_128405_(TAG_Y_OFFSET, pos.m_123342_());
        cmp.m_128405_(TAG_Z_OFFSET, pos.m_123343_());
        return cmp;
    }

    public static IRelic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, ResourceLocationHelper.prefix("challenge/loki_ring"));
    }
}

