/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;

public final class ToolCommons {
    private static boolean recCall = false;

    public static int damageItemIfPossible(ItemStack stack, int amount, LivingEntity entity, int manaPerDamage) {
        Player player;
        if (entity instanceof Player) {
            player = (Player)entity;
        } else {
            return amount;
        }
        while (amount > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, manaPerDamage, true)) {
            --amount;
        }
        return amount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBlocksInIteration(Player player, ItemStack stack, Level world, BlockPos centerPos, Vec3i startDelta, Vec3i endDelta, Predicate<BlockState> filter) {
        if (recCall) {
            return;
        }
        recCall = true;
        try {
            for (BlockPos iterPos : BlockPos.m_121940_((BlockPos)centerPos.m_141952_(startDelta), (BlockPos)centerPos.m_141952_(endDelta))) {
                if (iterPos.equals((Object)centerPos)) continue;
                ToolCommons.removeBlockWithDrops(player, stack, world, iterPos, filter);
            }
        }
        finally {
            recCall = false;
        }
    }

    public static void removeBlockWithDrops(Player player, ItemStack stack, Level world, BlockPos pos, Predicate<BlockState> filter) {
        boolean unminable;
        if (!world.m_46805_(pos)) {
            return;
        }
        BlockState blockstate = world.m_8055_(pos);
        boolean bl = unminable = blockstate.m_60625_(player, (BlockGetter)world, pos) == 0.0f;
        if (!world.f_46443_ && !unminable && filter.test(blockstate) && !blockstate.m_60795_()) {
            ItemStack save = player.m_21205_();
            player.m_21008_(InteractionHand.MAIN_HAND, stack);
            ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundLevelEventPacket(2001, pos, Block.m_49956_((BlockState)blockstate), false));
            ((ServerPlayer)player).f_8941_.m_9280_(pos);
            player.m_21008_(InteractionHand.MAIN_HAND, save);
        }
    }

    public static int getToolPriority(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof DiggerItem)) {
            return 0;
        }
        DiggerItem tool = (DiggerItem)item;
        Tier material = tool.m_43314_();
        int materialLevel = 0;
        if (material == BotaniaAPI.instance().getManasteelItemTier()) {
            materialLevel = 10;
        }
        if (material == BotaniaAPI.instance().getElementiumItemTier()) {
            materialLevel = 11;
        }
        if (material == BotaniaAPI.instance().getTerrasteelItemTier()) {
            materialLevel = 20;
        }
        int modifier = 0;
        if (stack.m_150930_(ModItems.terraPick)) {
            modifier = ItemTerraPick.getLevel(stack);
        }
        int efficiency = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)stack);
        return materialLevel * 100 + modifier * 10 + efficiency;
    }

    public static BlockHitResult raytraceFromEntity(Entity e, double distance, boolean fluids) {
        return (BlockHitResult)e.m_19907_(distance, 1.0f, fluids);
    }
}

