/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.block.CTBlockIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.function.RecipeFunctionSingle;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeManaInfusion;
import vazkii.botania.common.integration.crafttweaker.CTPlugin;

@Document(value="mods/Botania/recipe/manager/ManaInfusionRecipeManager")
@ZenRegister
@IRecipeHandler.For(value=IManaInfusionRecipe.class)
@ZenCodeType.Name(value="mods.botania.recipe.manager.ManaInfusionRecipeManager")
public class ManaInfusionRecipeManager
implements IRecipeManager<IManaInfusionRecipe>,
IRecipeHandler<IManaInfusionRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack output, IIngredient input, int mana, @ZenCodeType.Optional CTBlockIngredient catalyst, @ZenCodeType.OptionalString(value="") String group, @ZenCodeType.Optional RecipeFunctionSingle function) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = CraftTweakerConstants.rl((String)name);
        RecipeManaInfusion recipe = function == null ? new RecipeManaInfusion(resourceLocation, output.getInternal(), input.asVanillaIngredient(), mana, group, CTPlugin.blockIngredientToStateIngredient(catalyst)) : new InfusionWithFunction(resourceLocation, output.getInternal(), input.asVanillaIngredient(), mana, group, CTPlugin.blockIngredientToStateIngredient(catalyst), function);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)recipe));
    }

    public RecipeType<IManaInfusionRecipe> getRecipeType() {
        return ModRecipeTypes.MANA_INFUSION_TYPE;
    }

    public String dumpToCommandString(IRecipeManager manager, IManaInfusionRecipe recipe) {
        ArrayList<String> s = new ArrayList<String>();
        s.add(StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()));
        s.add(Services.PLATFORM.createMCItemStack(recipe.m_8043_()).getCommandString());
        IIngredient input = IIngredient.fromIngredient((Ingredient)((Ingredient)recipe.m_7527_().get(0)));
        s.add(input.getCommandString());
        s.add(String.valueOf(recipe.getManaToConsume()));
        s.add(recipe.getRecipeCatalyst() != null ? CTPlugin.ingredientToCommandString(recipe.getRecipeCatalyst()) : null);
        s.add(!recipe.m_6076_().equals("") ? recipe.m_6076_() : null);
        if (recipe instanceof InfusionWithFunction) {
            s.add("(usualOut, input) => { ... }");
        }
        ListIterator iterator = s.listIterator(s.size());
        while (iterator.hasPrevious() && iterator.previous() == null) {
            iterator.remove();
        }
        return s.stream().collect(Collectors.joining(", ", manager.getCommandString() + ".addRecipe(", ");"));
    }

    public Optional<Function<ResourceLocation, IManaInfusionRecipe>> replaceIngredients(IRecipeManager manager, IManaInfusionRecipe recipe, List<IReplacementRule> rules) {
        return IRecipeHandler.attemptReplacing((Object)((Ingredient)recipe.m_7527_().get(0)), Ingredient.class, (Recipe)recipe, rules).map(ingr -> {
            if (recipe instanceof InfusionWithFunction) {
                return id -> new InfusionWithFunction((ResourceLocation)id, recipe.m_8043_(), (Ingredient)ingr, recipe.getManaToConsume(), recipe.m_6076_(), recipe.getRecipeCatalyst(), ((InfusionWithFunction)recipe).getFunction());
            }
            return id -> new RecipeManaInfusion((ResourceLocation)id, recipe.m_8043_(), (Ingredient)ingr, recipe.getManaToConsume(), recipe.m_6076_(), recipe.getRecipeCatalyst());
        });
    }

    private static class InfusionWithFunction
    extends RecipeManaInfusion {
        private final RecipeFunctionSingle function;

        public InfusionWithFunction(ResourceLocation resourceLocation, ItemStack internal, Ingredient input1, int mana, String group, StateIngredient catalyst, RecipeFunctionSingle function) {
            super(resourceLocation, internal, input1, mana, group, catalyst);
            this.function = function;
        }

        @Override
        @Nonnull
        public ItemStack getRecipeOutput(@Nonnull ItemStack input) {
            return this.function.process(Services.PLATFORM.createMCItemStack(this.m_8043_()), Services.PLATFORM.createMCItemStack(input)).getInternal().m_41777_();
        }

        private RecipeFunctionSingle getFunction() {
            return this.function;
        }
    }
}

