/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import vazkii.botania.common.crafting.recipe.RecipeUtils;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemBlackHoleTalisman;
import vazkii.botania.common.item.ModItems;

public class BlackHoleTalismanExtractRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<BlackHoleTalismanExtractRecipe> SERIALIZER = new SimpleRecipeSerializer(BlackHoleTalismanExtractRecipe::new);

    public BlackHoleTalismanExtractRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundTalisman = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(ModItems.blackHoleTalisman) && !foundTalisman) {
                foundTalisman = true;
                continue;
            }
            return false;
        }
        return foundTalisman;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        Block block;
        ItemStack talisman = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            talisman = stack;
        }
        int count = ItemBlackHoleTalisman.getBlockCount(talisman);
        if (count > 0 && (block = ItemBlackHoleTalisman.getBlock(talisman)) != null) {
            return new ItemStack((ItemLike)block, Math.min(64, count));
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 0;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingContainer inv) {
        return RecipeUtils.getRemainingItemsSub((Container)inv, s -> {
            if (s.m_150930_(ModItems.blackHoleTalisman)) {
                int count = ItemBlackHoleTalisman.getBlockCount(s);
                if (count == 0) {
                    return ItemStack.f_41583_;
                }
                int extract = Math.min(64, count);
                ItemStack copy = s.m_41777_();
                copy.m_41764_(1);
                ItemBlackHoleTalisman.remove(copy, extract);
                ItemNBTHelper.setBoolean(copy, "active", false);
                return copy;
            }
            return null;
        });
    }
}

