/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.corporea;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.corporea.TileCorporeaBase;

public class TileCorporeaCrystalCube
extends TileCorporeaBase
implements ICorporeaRequestor,
IWandable {
    private static final String TAG_REQUEST_TARGET = "requestTarget";
    private static final String TAG_ITEM_COUNT = "itemCount";
    private static final String TAG_LOCK = "lock";
    private ItemStack requestTarget = ItemStack.f_41583_;
    private int itemCount = 0;
    private int ticks = 0;
    private int compValue = 0;
    public boolean locked = false;

    public TileCorporeaCrystalCube(BlockPos pos, BlockState state) {
        super(ModTiles.CORPOREA_CRYSTAL_CUBE, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TileCorporeaCrystalCube self) {
        ++self.ticks;
        if (self.ticks % 20 == 0) {
            self.updateCount();
        }
    }

    public void setRequestTarget(ItemStack stack) {
        if (!stack.m_41619_() && !this.locked) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            this.requestTarget = copy;
            this.updateCount();
            if (!this.f_58857_.f_46443_) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
        }
    }

    public ItemStack getRequestTarget() {
        return this.requestTarget;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void doRequest(boolean fullStack) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        ICorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && !this.requestTarget.m_41619_()) {
            int count = fullStack ? this.requestTarget.m_41741_() : 1;
            this.doCorporeaRequest(CorporeaHelper.instance().createMatcher(this.requestTarget, true), count, spark);
        }
    }

    private void updateCount() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        int sum = 0;
        ICorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && !this.requestTarget.m_41619_()) {
            List<ItemStack> stacks = CorporeaHelper.instance().requestItem(CorporeaHelper.instance().createMatcher(this.requestTarget, true), -1, spark, false).getStacks();
            for (ItemStack stack : stacks) {
                sum += stack.m_41613_();
            }
        }
        this.setCount(sum);
    }

    private void setCount(int count) {
        int oldCount = this.itemCount;
        this.itemCount = count;
        if (this.itemCount != oldCount) {
            int oldCompValue = this.compValue;
            this.compValue = CorporeaHelper.instance().signalStrengthForRequestSize(this.itemCount);
            if (this.compValue != oldCompValue && this.f_58857_ != null) {
                this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            }
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public void writePacketNBT(CompoundTag tag) {
        super.writePacketNBT(tag);
        CompoundTag cmp = new CompoundTag();
        if (!this.requestTarget.m_41619_()) {
            cmp = this.requestTarget.m_41739_(cmp);
        }
        tag.m_128365_(TAG_REQUEST_TARGET, (Tag)cmp);
        tag.m_128405_(TAG_ITEM_COUNT, this.itemCount);
        tag.m_128379_(TAG_LOCK, this.locked);
    }

    @Override
    public void readPacketNBT(CompoundTag tag) {
        super.readPacketNBT(tag);
        CompoundTag cmp = tag.m_128469_(TAG_REQUEST_TARGET);
        this.requestTarget = ItemStack.m_41712_((CompoundTag)cmp);
        this.setCount(tag.m_128451_(TAG_ITEM_COUNT));
        this.locked = tag.m_128471_(TAG_LOCK);
    }

    public int getComparatorValue() {
        return this.compValue;
    }

    @Override
    public void doCorporeaRequest(ICorporeaRequestMatcher request, int count, ICorporeaSpark spark) {
        if (!this.requestTarget.m_41619_()) {
            List<ItemStack> stacks = CorporeaHelper.instance().requestItem(request, count, spark, true).getStacks();
            spark.onItemsRequested(stacks);
            boolean did = false;
            int sum = 0;
            for (ItemStack reqStack : stacks) {
                ItemEntity item = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, reqStack);
                this.f_58857_.m_7967_((Entity)item);
                if (!this.requestTarget.m_41656_(reqStack)) continue;
                sum += reqStack.m_41613_();
                did = true;
            }
            if (did) {
                this.setCount(this.getItemCount() - sum);
            }
        }
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (player == null || player.m_6144_()) {
            boolean bl = this.locked = !this.locked;
            if (!this.f_58857_.f_46443_) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
            return true;
        }
        return false;
    }
}

