/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.ModBlocks;

public class BlockSpecialFlower
extends FlowerBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = BlockSpecialFlower.m_49796_((double)4.8, (double)0.0, (double)4.8, (double)12.8, (double)16.0, (double)12.8);
    private final Supplier<BlockEntityType<? extends TileEntitySpecialFlower>> blockEntityType;

    public BlockSpecialFlower(MobEffect stewEffect, int stewDuration, BlockBehaviour.Properties props, Supplier<BlockEntityType<? extends TileEntitySpecialFlower>> blockEntityType) {
        super(stewEffect, stewDuration, props);
        this.blockEntityType = blockEntityType;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, CollisionContext ctx) {
        Vec3 shift = state.m_60824_(world, pos);
        return SHAPE.m_83216_(shift.f_82479_, shift.f_82480_, shift.f_82481_);
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_60713_(ModBlocks.redStringRelay) || super.m_6266_(state, worldIn, pos);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int event, int param) {
        super.m_8133_(state, world, pos, event, param);
        BlockEntity tileentity = world.m_7702_(pos);
        return tileentity != null && tileentity.m_7531_(event, param);
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return this.blockEntityType.get().m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockMod.createTickerHelper(type, this.blockEntityType.get(), TileEntitySpecialFlower::commonTick);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        ((TileEntitySpecialFlower)level.m_7702_(pos)).setPlacedBy(level, pos, state, placer, stack);
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        BlockSpecialFlower.redstoneParticlesIfPowered(state, world, pos, rand);
    }

    public static void redstoneParticlesIfPowered(BlockState state, Level world, BlockPos pos, Random rand) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileEntityFunctionalFlower) {
            VoxelShape shape;
            TileEntityFunctionalFlower flower = (TileEntityFunctionalFlower)te;
            if (rand.nextBoolean() && flower.acceptsRedstone() && flower.redstoneSignal > 0 && !(shape = state.m_60808_((BlockGetter)world, pos)).m_83281_()) {
                AABB localBox = shape.m_83215_();
                BlockPos effPos = flower.getEffectivePos();
                double x = (double)effPos.m_123341_() + localBox.f_82288_ + rand.nextDouble() * (localBox.f_82291_ - localBox.f_82288_);
                double y = (double)effPos.m_123342_() + localBox.f_82289_ + rand.nextDouble() * (localBox.f_82292_ - localBox.f_82289_);
                double z = (double)effPos.m_123343_() + localBox.f_82290_ + rand.nextDouble() * (localBox.f_82293_ - localBox.f_82290_);
                world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }
}

