/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileLightRelay;

public class BlockLightLauncher
extends BlockModWaterloggable {
    private static final VoxelShape SHAPE = BlockLightLauncher.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);

    public BlockLightLauncher(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61448_});
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean power = world.m_46755_(pos) > 0;
        boolean powered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
        if (power && !powered) {
            this.pickUpEntities(world, pos);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!power && powered) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    private void pickUpEntities(Level world, BlockPos pos) {
        TileLightRelay relay;
        ArrayList<TileLightRelay> relays = new ArrayList<TileLightRelay>();
        for (Direction dir : Direction.values()) {
            BlockEntity tile = world.m_7702_(pos.m_142300_(dir));
            if (!(tile instanceof TileLightRelay) || (relay = (TileLightRelay)tile).getNextDestination() == null) continue;
            relays.add(relay);
        }
        if (!relays.isEmpty()) {
            AABB aabb = new AABB(pos, pos.m_142082_(1, 1, 1));
            List living = world.m_45976_(LivingEntity.class, aabb);
            List items = world.m_45976_(ItemEntity.class, aabb);
            for (Entity entity : Iterables.concat((Iterable)living, (Iterable)items)) {
                relay = (TileLightRelay)relays.get(world.f_46441_.nextInt(relays.size()));
                relay.mountEntity(entity);
            }
        }
    }
}

