/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui.bag;

import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import vazkii.botania.client.gui.SlotLocked;
import vazkii.botania.common.block.BlockModDoubleFlower;
import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.item.ItemFlowerBag;
import vazkii.botania.common.item.ModItems;

public class ContainerFlowerBag
extends AbstractContainerMenu {
    private final ItemStack bag;
    public final Container flowerBagInv;

    public static ContainerFlowerBag fromNetwork(int windowId, Inventory inv, FriendlyByteBuf buf) {
        InteractionHand hand = buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        return new ContainerFlowerBag(windowId, inv, inv.f_35978_.m_21120_(hand));
    }

    public ContainerFlowerBag(int windowId, Inventory playerInv, ItemStack bag) {
        super(ModItems.FLOWER_BAG_CONTAINER, windowId);
        int col;
        int row;
        this.bag = bag;
        this.flowerBagInv = !playerInv.f_35978_.f_19853_.f_46443_ ? ItemFlowerBag.getInventory(bag) : new SimpleContainer(ItemFlowerBag.SIZE);
        for (row = 0; row < 4; ++row) {
            for (col = 0; col < 8; ++col) {
                int slot = col + row * 8;
                this.m_38897_(new Slot(this.flowerBagInv, slot, 17 + col * 18, 26 + row * 18){

                    public boolean m_5857_(@Nonnull ItemStack stack) {
                        return ItemFlowerBag.isValid(this.m_150661_(), stack);
                    }
                });
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 120 + row * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (playerInv.m_8020_(i) == bag) {
                this.m_38897_(new SlotLocked((Container)playerInv, i, 8 + i * 18, 178));
                continue;
            }
            this.m_38897_(new Slot((Container)playerInv, i, 8 + i * 18, 178));
        }
    }

    public boolean m_6875_(@Nonnull Player player) {
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        return !main.m_41619_() && main == this.bag || !off.m_41619_() && off == this.bag;
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotIndex < 32) {
                if (!this.m_38903_(itemstack1, 32, 68, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                Slot destination;
                Block b = Block.m_49814_((Item)itemstack.m_41720_());
                int slotId = -1;
                if (b instanceof BlockModDoubleFlower) {
                    BlockModDoubleFlower flower = (BlockModDoubleFlower)b;
                    slotId = 16 + flower.color.m_41060_();
                } else if (b instanceof BlockModFlower) {
                    BlockModFlower flower = (BlockModFlower)b;
                    slotId = flower.color.m_41060_();
                }
                if (slotId >= 0 && slotId < 32 && (destination = (Slot)this.f_38839_.get(slotId)).m_5857_(itemstack) && !this.m_38903_(itemstack1, slotId, slotId + 1, true)) {
                    return ItemStack.f_41583_;
                }
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }
}

