/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.subtile;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.subtile.TileEntityBindableSpecialFlower;

public abstract class TileEntityGeneratingFlower
extends TileEntityBindableSpecialFlower<IManaCollector> {
    private static final ResourceLocation SPREADER_ID = new ResourceLocation("botania", "mana_spreader");
    public static final int LINK_RANGE = 6;
    private static final String TAG_MANA = "mana";
    private int mana;

    public TileEntityGeneratingFlower(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, IManaCollector.class);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_) {
            double particleChance = 1.0 - (double)this.getMana() / (double)this.getMaxMana() / 3.5;
            int color = this.getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (Math.random() > particleChance) {
                Vec3 offset = this.m_58904_().m_8055_(this.m_58899_()).m_60824_((BlockGetter)this.m_58904_(), this.m_58899_());
                double x = (double)this.m_58899_().m_123341_() + offset.f_82479_;
                double y = (double)this.m_58899_().m_123342_() + offset.f_82480_;
                double z = (double)this.m_58899_().m_123343_() + offset.f_82481_;
                BotaniaAPI.instance().sparkleFX(this.m_58904_(), x + 0.3 + Math.random() * 0.5, y + 0.5 + Math.random() * 0.5, z + 0.3 + Math.random() * 0.5, red, green, blue, (float)Math.random(), 5);
            }
        }
        this.emptyManaIntoCollector();
    }

    @Override
    public int getBindingRadius() {
        return 6;
    }

    @Override
    @Nullable
    public BlockPos findClosestTarget() {
        IManaNetwork network = BotaniaAPI.instance().getManaNetworkInstance();
        IManaCollector closestCollector = network.getClosestCollector(this.m_58899_(), this.m_58904_(), this.getBindingRadius());
        return closestCollector == null ? null : closestCollector.getManaReceiverPos();
    }

    public void emptyManaIntoCollector() {
        IManaCollector collector = (IManaCollector)this.findBoundTile();
        if (collector != null && !collector.isFull() && this.getMana() > 0) {
            int manaval = Math.min(this.getMana(), collector.getMaxMana() - collector.getCurrentMana());
            this.addMana(-manaval);
            collector.receiveMana(manaval);
            this.sync();
        }
    }

    public void addMana(int mana) {
        this.mana = Math.min(this.getMaxMana(), this.getMana() + mana);
        this.m_6596_();
    }

    public int getMana() {
        return this.mana;
    }

    public abstract int getMaxMana();

    public abstract int getColor();

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.mana = cmp.m_128451_(TAG_MANA);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_MANA, this.getMana());
    }

    public ItemStack getHudIcon() {
        return Registry.f_122827_.m_6612_(SPREADER_ID).map(ItemStack::new).orElse(ItemStack.f_41583_);
    }

    public static class GeneratingWandHud<T extends TileEntityGeneratingFlower>
    implements IWandHUD {
        protected final T flower;

        public GeneratingWandHud(T flower) {
            this.flower = flower;
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            String name = I18n.m_118938_((String)this.flower.m_58900_().m_60734_().m_7705_(), (Object[])new Object[0]);
            int color = ((TileEntityGeneratingFlower)this.flower).getColor();
            BotaniaAPIClient.instance().drawComplexManaHUD(ms, color, ((TileEntityGeneratingFlower)this.flower).getMana(), ((TileEntityGeneratingFlower)this.flower).getMaxMana(), name, ((TileEntityGeneratingFlower)this.flower).getHudIcon(), ((TileEntityBindableSpecialFlower)this.flower).isValidBinding());
        }
    }
}

