/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import party.lemons.biomemakeover.block.BMSlabBlock;
import party.lemons.biomemakeover.block.BMStairBlock;

public class DecorationBlockInfo {
    public static final List<DecorationBlockInfo> REGISTERED_FACTORIES = Lists.newArrayList();
    private final List<Type> types = Lists.newArrayList();
    private final Map<Type, Supplier<Block>> blocks = Maps.newHashMap();
    private final String name;
    private final BlockBehaviour.Properties settings;
    private final Supplier<Block> base;
    private final Consumer<Supplier<Block>> callback;
    private final String modid;
    private final CreativeModeTab tab;
    protected Supplier<Item.Properties> blockItemProperties;

    public DecorationBlockInfo(String modid, CreativeModeTab tab, String name, Supplier<Block> baseBlock, BlockBehaviour.Properties settings) {
        this(modid, tab, name, baseBlock, settings, null);
    }

    public DecorationBlockInfo(String modid, CreativeModeTab tab, String name, Supplier<Block> baseBlock, BlockBehaviour.Properties settings, Consumer<Supplier<Block>> callback) {
        this.modid = modid;
        this.name = name;
        this.settings = settings;
        this.base = baseBlock;
        this.tab = tab;
        this.callback = callback;
        this.blockItemProperties = () -> new Item.Properties().m_41491_(this.tab);
    }

    public DecorationBlockInfo slab() {
        this.types.add(Type.SLAB);
        return this;
    }

    public DecorationBlockInfo stair() {
        this.types.add(Type.STAIR);
        return this;
    }

    public DecorationBlockInfo wall() {
        this.types.add(Type.WALL);
        return this;
    }

    public DecorationBlockInfo all() {
        return this.slab().stair().wall();
    }

    public DecorationBlockInfo blocKItemProperties(Supplier<Item.Properties> properties) {
        this.blockItemProperties = properties;
        return this;
    }

    private void set(Type type, Supplier<Block> block) {
        this.blocks.put(type, block);
    }

    public Supplier<Block> get(Type type) {
        return this.blocks.get((Object)type);
    }

    public boolean has(Type type) {
        return this.blocks.containsKey((Object)type);
    }

    public Supplier<Block> getBase() {
        return this.base;
    }

    public DecorationBlockInfo register(DeferredRegister<Block> blockRegister, DeferredRegister<Item> itemRegister) {
        for (Type type : this.types) {
            switch (type) {
                case SLAB: {
                    this.set(type, () -> new BMSlabBlock(this.settings));
                    break;
                }
                case STAIR: {
                    this.set(type, () -> new BMStairBlock(this.base.get().m_49966_(), this.settings));
                    break;
                }
                case WALL: {
                    this.set(type, () -> new WallBlock(this.settings));
                }
            }
        }
        for (Type key : this.blocks.keySet()) {
            Supplier<Block> bl = this.blocks.get((Object)key);
            ResourceLocation id = key.make(this.modid, this.name);
            RegistrySupplier regBlock = blockRegister.register(id, bl);
            itemRegister.register(id, () -> new BlockItem((Block)regBlock.get(), this.blockItemProperties.get()));
            if (this.callback == null) continue;
            this.callback.accept(bl);
        }
        REGISTERED_FACTORIES.add(this);
        return this;
    }

    public static enum Type {
        SLAB("slab"),
        STAIR("stairs"),
        WALL("wall");

        private final String postfix;

        private Type(String postfix) {
            this.postfix = postfix;
        }

        public ResourceLocation make(String modid, String name) {
            return new ResourceLocation(modid, name + "_" + this.postfix);
        }
    }
}

