/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;

public class WeightedList<T> {
    private final List<Entry<T>> entries = Lists.newArrayList();
    private int totalWeight = 0;

    public void add(T object, int weight) {
        this.entries.add(new Entry<T>(object, weight));
        this.totalWeight += weight;
    }

    public T sample() {
        Collections.shuffle(this.entries);
        int w = this.totalWeight;
        for (Entry<T> entry : this.entries) {
            if ((w -= entry.weight) > 0) continue;
            return entry.object;
        }
        throw new RuntimeException("Weighted List Was Empty");
    }

    private record Entry<T>(T object, int weight) {
    }
}

