/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util;

import java.util.Collection;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableInt;
import party.lemons.biomemakeover.init.BMEntities;

public final class EntityUtil {
    public static void applyProjectileResistance(Iterable<ItemStack> equipment, MutableInt resistance) {
        MutableInt slotIndex = new MutableInt(0);
        equipment.forEach(e -> {
            EquipmentSlot slot;
            if (!e.m_41619_() && e.m_41638_(slot = EquipmentSlot.values()[2 + slotIndex.getValue()]).containsKey(BMEntities.ATT_PROJECTILE_RESISTANCE.get())) {
                Collection modifiers = e.m_41638_(slot).get((Object)((Attribute)BMEntities.ATT_PROJECTILE_RESISTANCE.get()));
                for (AttributeModifier mod : modifiers) {
                    resistance.add((Number)mod.m_22218_());
                }
            }
            slotIndex.add(1);
        });
    }

    public static double getProjectileResistance(LivingEntity e) {
        double res = 0.0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack st = e.m_6844_(slot);
            if (st.m_41619_() || !st.m_41638_(slot).containsKey(BMEntities.ATT_PROJECTILE_RESISTANCE.get())) continue;
            Collection modifiers = st.m_41638_(slot).get((Object)((Attribute)BMEntities.ATT_PROJECTILE_RESISTANCE.get()));
            for (AttributeModifier mod : modifiers) {
                res += mod.m_22218_();
            }
        }
        return res;
    }

    private EntityUtil() {
    }

    public static boolean attemptProjectileResistanceBlock(LivingEntity entity, DamageSource source) {
        double protection;
        if (source.m_19360_() && (protection = EntityUtil.getProjectileResistance(entity)) > 0.0 && entity.m_21187_().nextDouble() * 30.0 < protection) {
            entity.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + entity.m_21187_().nextFloat() * 0.4f);
            return true;
        }
        return false;
    }

    public static void scatterItemStack(Entity e, ItemStack stack) {
        Containers.m_18992_((Level)e.f_19853_, (double)e.m_20185_(), (double)e.m_20186_(), (double)e.m_20189_(), (ItemStack)stack);
    }
}

