/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.mixin.golem;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import party.lemons.biomemakeover.level.golem.GolemHandler;
import party.lemons.biomemakeover.util.access.CarvedPumpkinAccess;

@Mixin(value={CarvedPumpkinBlock.class})
public class CarvedPumpkinBlockMixin
implements CarvedPumpkinAccess {
    @Shadow
    @Final
    private static Predicate<BlockState> f_51372_;

    @Inject(at={@At(value="HEAD")}, method={"canSpawnGolem"}, cancellable=true)
    public void canSpawnGolem(LevelReader levelReader, BlockPos blockPos, CallbackInfoReturnable<Boolean> cbi) {
        if (GolemHandler.canDispenseGolem(levelReader, blockPos)) {
            cbi.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"trySpawnGolem"}, cancellable=true)
    private void trySpawnGolem(Level level, BlockPos blockPos, CallbackInfo cbi) {
        if (GolemHandler.checkAndCreateGolem(level, blockPos)) {
            cbi.cancel();
        }
    }

    @Override
    public Predicate<BlockState> bm_isGolemHeadBlock() {
        return f_51372_;
    }
}

