/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class WaterTreeFeature
extends Feature<TreeConfiguration> {
    public WaterTreeFeature(Codec<TreeConfiguration> codec) {
        super(codec);
    }

    public static boolean isFree(LevelSimulatedReader levelSimulatedReader, BlockPos blockPos) {
        return WaterTreeFeature.validTreePos(levelSimulatedReader, blockPos) || levelSimulatedReader.m_7433_(blockPos, blockState -> blockState.m_204336_(BlockTags.f_13106_));
    }

    private static boolean isVine(LevelSimulatedReader levelSimulatedReader, BlockPos blockPos) {
        return levelSimulatedReader.m_7433_(blockPos, blockState -> blockState.m_60713_(Blocks.f_50191_));
    }

    private static boolean isBlockWater(LevelSimulatedReader levelSimulatedReader, BlockPos blockPos) {
        return levelSimulatedReader.m_7433_(blockPos, blockState -> blockState.m_60713_(Blocks.f_49990_));
    }

    private static void setBlockKnownShape(LevelWriter levelWriter, BlockPos blockPos, BlockState blockState) {
        levelWriter.m_7731_(blockPos, blockState, 19);
    }

    private static boolean isReplaceablePlant(LevelSimulatedReader levelSimulatedReader, BlockPos blockPos) {
        return levelSimulatedReader.m_7433_(blockPos, blockState -> {
            Material material = blockState.m_60767_();
            return material == Material.f_76302_;
        });
    }

    public static boolean validTreePos(LevelSimulatedReader levelSimulatedReader, BlockPos blockPos) {
        return TreeFeature.m_67267_((LevelSimulatedReader)levelSimulatedReader, (BlockPos)blockPos) || WaterTreeFeature.isReplaceablePlant(levelSimulatedReader, blockPos) || WaterTreeFeature.isBlockWater(levelSimulatedReader, blockPos);
    }

    private boolean doPlace(WorldGenLevel worldGenLevel, Random random, BlockPos blockPos, BiConsumer<BlockPos, BlockState> biConsumer, BiConsumer<BlockPos, BlockState> biConsumer2, TreeConfiguration treeConfiguration) {
        int i = treeConfiguration.f_68190_.m_70309_(random);
        int j = treeConfiguration.f_68189_.m_5969_(random, i, treeConfiguration);
        int k = i - j;
        int l = treeConfiguration.f_68189_.m_5937_(random, k);
        if (blockPos.m_123342_() < worldGenLevel.m_141937_() + 1 || blockPos.m_123342_() + i + 1 > worldGenLevel.m_151558_()) {
            return false;
        }
        OptionalInt optionalInt = treeConfiguration.f_68191_.m_68295_();
        int m = this.getMaxFreeTreeHeight((LevelSimulatedReader)worldGenLevel, i, blockPos, treeConfiguration);
        if (!(m >= i || optionalInt.isPresent() && m >= optionalInt.getAsInt())) {
            return false;
        }
        List list = treeConfiguration.f_68190_.m_142625_((LevelSimulatedReader)worldGenLevel, biConsumer, random, m, blockPos, treeConfiguration);
        list.forEach(foliageAttachment -> treeConfiguration.f_68189_.m_161413_((LevelSimulatedReader)worldGenLevel, biConsumer2, random, treeConfiguration, m, foliageAttachment, j, l));
        return true;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader levelSimulatedReader, int i, BlockPos blockPos, TreeConfiguration treeConfiguration) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int j = 0; j <= i + 1; ++j) {
            int k = treeConfiguration.f_68191_.m_6133_(i, j);
            for (int l = -k; l <= k; ++l) {
                for (int m = -k; m <= k; ++m) {
                    mutableBlockPos.m_122154_((Vec3i)blockPos, l, j, m);
                    if (WaterTreeFeature.isFree(levelSimulatedReader, (BlockPos)mutableBlockPos) && (treeConfiguration.f_68193_ || !WaterTreeFeature.isVine(levelSimulatedReader, (BlockPos)mutableBlockPos))) continue;
                    return j - 2;
                }
            }
        }
        return i;
    }

    protected void m_5974_(LevelWriter levelWriter, BlockPos blockPos, BlockState blockState) {
        WaterTreeFeature.setBlockKnownShape(levelWriter, blockPos, blockState);
    }

    public final boolean m_142674_(FeaturePlaceContext<TreeConfiguration> featurePlaceContext) {
        WorldGenLevel worldGenLevel = featurePlaceContext.m_159774_();
        Random random = featurePlaceContext.m_159776_();
        BlockPos blockPos2 = featurePlaceContext.m_159777_();
        if (featurePlaceContext.m_159774_().m_6425_(featurePlaceContext.m_159777_()).m_76152_() != Fluids.f_76193_) {
            return false;
        }
        TreeConfiguration treeConfiguration = (TreeConfiguration)featurePlaceContext.m_159778_();
        HashSet set = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biConsumer = (blockPos, blockState) -> {
            set.add(blockPos.m_7949_());
            worldGenLevel.m_7731_(blockPos, blockState, 19);
        };
        BiConsumer<BlockPos, BlockState> biConsumer2 = (blockPos, blockState) -> {
            set2.add(blockPos.m_7949_());
            worldGenLevel.m_7731_(blockPos, blockState, 19);
        };
        BiConsumer<BlockPos, BlockState> biConsumer3 = (blockPos, blockState) -> {
            set3.add(blockPos.m_7949_());
            worldGenLevel.m_7731_(blockPos, blockState, 19);
        };
        boolean bl = this.doPlace(worldGenLevel, random, blockPos2, biConsumer, biConsumer2, treeConfiguration);
        if (!bl || set.isEmpty() && set2.isEmpty()) {
            return false;
        }
        if (!treeConfiguration.f_68187_.isEmpty()) {
            ArrayList list = Lists.newArrayList((Iterable)set);
            ArrayList list2 = Lists.newArrayList((Iterable)set2);
            list.sort(Comparator.comparingInt(Vec3i::m_123342_));
            list2.sort(Comparator.comparingInt(Vec3i::m_123342_));
            treeConfiguration.f_68187_.forEach(treeDecorator -> treeDecorator.m_142741_((LevelSimulatedReader)worldGenLevel, biConsumer3, random, (List)list, (List)list2));
        }
        return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)set, (Iterable)set2, (Iterable)set3)).map(bb -> {
            DiscreteVoxelShape discreteVoxelShape = WaterTreeFeature.updateLeaves((LevelAccessor)worldGenLevel, bb, set, set3);
            StructureTemplate.m_74510_((LevelAccessor)worldGenLevel, (int)3, (DiscreteVoxelShape)discreteVoxelShape, (int)bb.m_162395_(), (int)bb.m_162396_(), (int)bb.m_162398_());
            return true;
        }).orElse(false);
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor levelAccessor, BoundingBox boundingBox, Set<BlockPos> set, Set<BlockPos> set2) {
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape discreteVoxelShape = new BitSetDiscreteVoxelShape(boundingBox.m_71056_(), boundingBox.m_71057_(), boundingBox.m_71058_());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (BlockPos blockPos : Lists.newArrayList(set2)) {
            if (!boundingBox.m_71051_((Vec3i)blockPos)) continue;
            discreteVoxelShape.m_142703_(blockPos.m_123341_() - boundingBox.m_162395_(), blockPos.m_123342_() - boundingBox.m_162396_(), blockPos.m_123343_() - boundingBox.m_162398_());
        }
        for (BlockPos blockPos : Lists.newArrayList(set)) {
            if (boundingBox.m_71051_((Vec3i)blockPos)) {
                discreteVoxelShape.m_142703_(blockPos.m_123341_() - boundingBox.m_162395_(), blockPos.m_123342_() - boundingBox.m_162396_(), blockPos.m_123343_() - boundingBox.m_162398_());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockState;
                mutableBlockPos.m_122159_((Vec3i)blockPos, direction);
                if (set.contains(mutableBlockPos) || !(blockState = levelAccessor.m_8055_((BlockPos)mutableBlockPos)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)list.get(0)).add(mutableBlockPos.m_7949_());
                WaterTreeFeature.setBlockKnownShape((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
                if (!boundingBox.m_71051_((Vec3i)mutableBlockPos)) continue;
                discreteVoxelShape.m_142703_(mutableBlockPos.m_123341_() - boundingBox.m_162395_(), mutableBlockPos.m_123342_() - boundingBox.m_162396_(), mutableBlockPos.m_123343_() - boundingBox.m_162398_());
            }
        }
        for (int k = 1; k < 6; ++k) {
            Set set3 = (Set)list.get(k - 1);
            Set set4 = (Set)list.get(k);
            for (BlockPos blockPos2 : set3) {
                if (boundingBox.m_71051_((Vec3i)blockPos2)) {
                    discreteVoxelShape.m_142703_(blockPos2.m_123341_() - boundingBox.m_162395_(), blockPos2.m_123342_() - boundingBox.m_162396_(), blockPos2.m_123343_() - boundingBox.m_162398_());
                }
                for (Direction direction2 : Direction.values()) {
                    int l;
                    BlockState blockState2;
                    mutableBlockPos.m_122159_((Vec3i)blockPos2, direction2);
                    if (set3.contains(mutableBlockPos) || set4.contains(mutableBlockPos) || !(blockState2 = levelAccessor.m_8055_((BlockPos)mutableBlockPos)).m_61138_((Property)BlockStateProperties.f_61414_) || (l = ((Integer)blockState2.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= k + 1) continue;
                    BlockState blockState3 = (BlockState)blockState2.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(k + 1));
                    WaterTreeFeature.setBlockKnownShape((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, blockState3);
                    if (boundingBox.m_71051_((Vec3i)mutableBlockPos)) {
                        discreteVoxelShape.m_142703_(mutableBlockPos.m_123341_() - boundingBox.m_162395_(), mutableBlockPos.m_123342_() - boundingBox.m_162396_(), mutableBlockPos.m_123343_() - boundingBox.m_162398_());
                    }
                    set4.add(mutableBlockPos.m_7949_());
                }
            }
        }
        return discreteVoxelShape;
    }
}

