/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import party.lemons.biomemakeover.util.RandomUtil;

public class SurfaceFossilFeature
extends Feature<NoneFeatureConfiguration> {
    private static final ResourceLocation[] FOSSILS = new ResourceLocation[]{new ResourceLocation("fossil/spine_1"), new ResourceLocation("fossil/spine_2"), new ResourceLocation("fossil/spine_3"), new ResourceLocation("fossil/spine_4"), new ResourceLocation("nether_fossils/fossil_1"), new ResourceLocation("nether_fossils/fossil_2"), new ResourceLocation("nether_fossils/fossil_3"), new ResourceLocation("nether_fossils/fossil_4"), new ResourceLocation("nether_fossils/fossil_5"), new ResourceLocation("nether_fossils/fossil_6"), new ResourceLocation("nether_fossils/fossil_7"), new ResourceLocation("nether_fossils/fossil_8"), new ResourceLocation("nether_fossils/fossil_9"), new ResourceLocation("nether_fossils/fossil_10"), new ResourceLocation("nether_fossils/fossil_11"), new ResourceLocation("nether_fossils/fossil_12"), new ResourceLocation("nether_fossils/fossil_13"), new ResourceLocation("nether_fossils/fossil_14")};

    public SurfaceFossilFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        Random random = ctx.m_159776_();
        WorldGenLevel worldGenLevel = ctx.m_159774_();
        BlockPos blockPos = ctx.m_159777_();
        Rotation rotation = Rotation.m_55956_((Random)random);
        int fossilIndex = random.nextInt(FOSSILS.length);
        StructureManager structureManager = worldGenLevel.m_6018_().m_142572_().m_129909_();
        StructureTemplate structureTemplate = structureManager.m_74341_(FOSSILS[fossilIndex]);
        ChunkPos chunkPos = new ChunkPos(blockPos);
        BoundingBox boundingBox = new BoundingBox(chunkPos.m_45604_() - 16, worldGenLevel.m_141937_(), chunkPos.m_45605_() - 16, chunkPos.m_45608_() + 16, worldGenLevel.m_151558_(), chunkPos.m_45609_() + 16);
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings().m_74379_(rotation).m_74381_(boundingBox).m_74390_(random);
        Vec3i size = structureTemplate.m_163808_(rotation);
        BlockPos position = blockPos.m_142082_(-size.m_123341_() / 2, 0, -size.m_123343_() / 2);
        int yLevel = blockPos.m_123342_();
        for (int xx = 0; xx < size.m_123341_(); ++xx) {
            for (int zz = 0; zz < size.m_123343_(); ++zz) {
                yLevel = Math.min(yLevel, worldGenLevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, position.m_123341_() + xx, position.m_123343_() + zz));
            }
        }
        if (fossilIndex < 4) {
            yLevel -= RandomUtil.randomRange(1, Math.max(2, size.m_123342_() - 2));
        }
        BlockPos placePotion = structureTemplate.m_74583_(position.m_175288_(yLevel), Mirror.NONE, rotation);
        structurePlaceSettings.m_74394_();
        structureTemplate.m_74536_((ServerLevelAccessor)worldGenLevel, placePotion, placePotion, structurePlaceSettings, random, 4);
        structurePlaceSettings.m_74394_();
        return true;
    }
}

