/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.JigsawFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMWorldGen;
import party.lemons.biomemakeover.util.RandomUtil;
import party.lemons.biomemakeover.util.registry.RegistryHelper;

public class GhostTownFeature
extends JigsawFeature {
    public static final WeightedRandomList<MobSpawnSettings.SpawnerData> SPAWNS = WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)BMEntities.GHOST.get(), 8, 1, 1)});
    public static final Holder<StructureProcessorList> ROADS_PROCESSOR = BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123863_, (ResourceLocation)BiomeMakeover.ID("roads_ghosttown"), (Object)new StructureProcessorList((List)ImmutableList.of((Object)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_152481_), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_50705_.m_49966_()))), (Object)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_152481_, 0.3f), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_49993_.m_49966_()))), (Object)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_49993_), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_49990_.m_49966_()))), (Object)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50493_), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_49990_.m_49966_()))))));
    private static final Holder<StructureTemplatePool> POOL = Pools.m_211103_((StructureTemplatePool)new StructureTemplatePool(BiomeMakeover.ID("ghosttown/centers"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/roads/street_01", ROADS_PROCESSOR), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/roads/street_02", ROADS_PROCESSOR), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/roads/street_03", ROADS_PROCESSOR), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/roads/street_04", ROADS_PROCESSOR), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/roads/street_05", ROADS_PROCESSOR), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/roads/street_06", ROADS_PROCESSOR), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/roads/street_07", ROADS_PROCESSOR), (Object)2)), StructureTemplatePool.Projection.RIGID));
    public static final JigsawConfiguration CONFIG = new JigsawConfiguration(POOL, 3);
    public static final GhostTownLootProcessor GHOST_TOWN_LOOT_PROCESSOR = new GhostTownLootProcessor();
    public static final Codec<GhostTownLootProcessor> GHOST_TOWN_PROCESSOR_CODEC = Codec.unit(() -> GHOST_TOWN_LOOT_PROCESSOR);
    public static final StructureProcessorType<GhostTownLootProcessor> GHOST_TOWN_PROCESSOR = () -> GHOST_TOWN_PROCESSOR_CODEC;

    public GhostTownFeature(Codec<JigsawConfiguration> codec) {
        super(codec, 0, true, true, context -> true);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static void init() {
        RegistryHelper.register("biomemakeover", Registry.f_122891_, StructureProcessorType.class, BMWorldGen.Badlands.class, new RegistryHelper.RegistryCallback[0]);
        Holder BUILDING_PROCESSOR = BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123863_, (ResourceLocation)BiomeMakeover.ID("buildings_ghosttown"), (Object)new StructureProcessorList((List)ImmutableList.of((Object)new RuleProcessor(BMBlocks.BRICK_TO_TERRACOTTA.keySet().stream().map(b -> new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)b.get(), 0.25f), (RuleTest)AlwaysTrueTest.f_73954_, BMBlocks.BRICK_TO_TERRACOTTA.get(b).m_49966_())).collect(Collectors.toList())))));
        Pools.m_211103_((StructureTemplatePool)new StructureTemplatePool(BiomeMakeover.ID("ghosttown/roads"), new ResourceLocation("village/plains/terminators"), (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/roads/street_01", ROADS_PROCESSOR), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/roads/street_02", ROADS_PROCESSOR), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/roads/street_03", ROADS_PROCESSOR), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/roads/street_04", ROADS_PROCESSOR), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/roads/street_05", ROADS_PROCESSOR), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/roads/street_06", ROADS_PROCESSOR), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/roads/street_07", ROADS_PROCESSOR), (Object)2)), StructureTemplatePool.Projection.RIGID));
        Pools.m_211103_((StructureTemplatePool)new StructureTemplatePool(BiomeMakeover.ID("ghosttown/buildings"), new ResourceLocation("village/plains/terminators"), (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_small_01", (Holder)BUILDING_PROCESSOR), (Object)15), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_small_02", (Holder)BUILDING_PROCESSOR), (Object)15), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_small_03", (Holder)BUILDING_PROCESSOR), (Object)15), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_small_04", (Holder)BUILDING_PROCESSOR), (Object)15), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_small_05", (Holder)BUILDING_PROCESSOR), (Object)15), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_small_06", (Holder)BUILDING_PROCESSOR), (Object)15), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_small_07", (Holder)BUILDING_PROCESSOR), (Object)15), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_small_08", (Holder)BUILDING_PROCESSOR), (Object)15), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_small_09", (Holder)BUILDING_PROCESSOR), (Object)15), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_small_10", (Holder)BUILDING_PROCESSOR), (Object)15), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_small_11", (Holder)BUILDING_PROCESSOR), (Object)15), (Object)Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_small_12", (Holder)BUILDING_PROCESSOR), (Object)15), (Object[])new Pair[]{Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_medium_01", (Holder)BUILDING_PROCESSOR), (Object)15), Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_medium_02", (Holder)BUILDING_PROCESSOR), (Object)15), Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_medium_03", (Holder)BUILDING_PROCESSOR), (Object)15), Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_medium_04", (Holder)BUILDING_PROCESSOR), (Object)15), Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_medium_05", (Holder)BUILDING_PROCESSOR), (Object)15), Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_medium_06", (Holder)BUILDING_PROCESSOR), (Object)15), Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_large_01", (Holder)BUILDING_PROCESSOR), (Object)8), Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_large_02", (Holder)BUILDING_PROCESSOR), (Object)8), Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_large_03", (Holder)BUILDING_PROCESSOR), (Object)8), Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_large_04", (Holder)BUILDING_PROCESSOR), (Object)8), Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/houses/house_large_05", (Holder)BUILDING_PROCESSOR), (Object)8), Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/decoration/water_tower_1", (Holder)BUILDING_PROCESSOR), (Object)15), Pair.of((Object)StructurePoolElement.m_210512_((String)"biomemakeover:ghosttown/decoration/water_tower_2", (Holder)BUILDING_PROCESSOR), (Object)15)}), StructureTemplatePool.Projection.RIGID));
        Pools.m_211103_((StructureTemplatePool)new StructureTemplatePool(BiomeMakeover.ID("ghosttown/decoration"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"biomemakeover:ghosttown/decoration/barrel_decoration"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"biomemakeover:ghosttown/decoration/hay_decoration"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"biomemakeover:ghosttown/decoration/hay_decoration_2"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"biomemakeover:ghosttown/decoration/lamp_decoration"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"biomemakeover:ghosttown/decoration/well_decoration"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"biomemakeover:ghosttown/decoration/trough_decoration"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"biomemakeover:ghosttown/decoration/lamp_decoration_2"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"biomemakeover:ghosttown/decoration/cactus_decoration"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"biomemakeover:ghosttown/decoration/bell_decoration_1"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"biomemakeover:ghosttown/decoration/hay_well_decoration"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"biomemakeover:ghosttown/decoration/tree_decoration_1"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"biomemakeover:ghosttown/decoration/tree_decoration_2"), (Object)2), (Object[])new Pair[]{Pair.of((Object)StructurePoolElement.m_210507_((String)"biomemakeover:ghosttown/decoration/water_tower_2"), (Object)2)}), StructureTemplatePool.Projection.RIGID));
    }

    public static class GhostTownLootProcessor
    extends StructureProcessor {
        public static final GhostTownLootProcessor INSTANCE = new GhostTownLootProcessor();
        public static final Codec<GhostTownLootProcessor> CODEC = Codec.unit(() -> INSTANCE);

        @Nullable
        public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo info, StructureTemplate.StructureBlockInfo info2, StructurePlaceSettings data) {
            BlockEntity be;
            BlockState blockState = info2.f_74676_;
            if (blockState.m_60734_() == Blocks.f_50618_ && (be = worldView.m_7702_(pos)) instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrel = (BarrelBlockEntity)be;
                barrel.m_59626_(BiomeMakeover.ID("ghost_town/loot_" + RandomUtil.RANDOM.nextInt(3)), RandomUtil.RANDOM.nextLong());
            }
            return info2;
        }

        protected StructureProcessorType<?> m_6953_() {
            return GHOST_TOWN_PROCESSOR;
        }
    }
}

