/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import party.lemons.biomemakeover.entity.BMBoatEntity;
import party.lemons.biomemakeover.item.BMItem;
import party.lemons.biomemakeover.util.registry.boat.BoatType;

public class BMBoatItem
extends BMItem {
    private final Supplier<BoatType> type;

    public BMBoatItem(Supplier<BoatType> boatType, Item.Properties settings) {
        super(settings);
        this.type = boatType;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new BMBoatDispenseItemBehavior(boatType));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        BlockHitResult hitResult = BoatItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        Vec3 vec3 = player.m_20252_(1.0f);
        double scale = 5.0;
        List list = level.m_6249_((Entity)player, player.m_142469_().m_82369_(vec3.m_82490_(scale)).m_82400_(1.0), EntitySelector.f_20408_.and(Entity::m_6087_));
        if (!list.isEmpty()) {
            Vec3 vec32 = player.m_146892_();
            for (Entity entity : list) {
                AABB aABB = entity.m_142469_().m_82400_((double)entity.m_6143_());
                if (!aABB.m_82390_(vec32)) continue;
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BMBoatEntity boatEntity = this.createBoat(level, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_, player.m_146908_());
            if (!level.m_45756_((Entity)boatEntity, boatEntity.m_142469_())) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            if (!level.f_46443_) {
                level.m_7967_((Entity)boatEntity);
                level.m_142346_((Entity)player, GameEvent.f_157810_, new BlockPos(hitResult.m_82450_()));
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public BMBoatEntity createBoat(Level world, double x, double y, double z, float yaw) {
        BMBoatEntity boatEntity = new BMBoatEntity(world, x, y, z);
        boatEntity.setBoatType(this.type.get());
        boatEntity.m_146922_(yaw);
        return boatEntity;
    }

    private class BMBoatDispenseItemBehavior
    extends DefaultDispenseItemBehavior {
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
        private Supplier<BoatType> type;

        public BMBoatDispenseItemBehavior(Supplier<BoatType> type) {
            this.type = type;
        }

        public ItemStack m_7498_(BlockSource blockSource, ItemStack itemStack) {
            double g;
            Direction direction = (Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel level = blockSource.m_7727_();
            double d = blockSource.m_7096_() + (double)((float)direction.m_122429_() * 1.125f);
            double e = blockSource.m_7098_() + (double)((float)direction.m_122430_() * 1.125f);
            double f = blockSource.m_7094_() + (double)((float)direction.m_122431_() * 1.125f);
            BlockPos blockPos = blockSource.m_7961_().m_142300_(direction);
            if (level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)) {
                g = 1.0;
            } else if (level.m_8055_(blockPos).m_60795_() && level.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_)) {
                g = 0.0;
            } else {
                return this.defaultDispenseItemBehavior.m_6115_(blockSource, itemStack);
            }
            BMBoatEntity boat = new BMBoatEntity((Level)level, d, e + g, f);
            boat.setBoatType(this.type.get());
            boat.m_146922_(direction.m_122435_());
            level.m_7967_((Entity)boat);
            itemStack.m_41774_(1);
            return itemStack;
        }

        protected void m_6823_(BlockSource blockSource) {
            blockSource.m_7727_().m_46796_(1000, blockSource.m_7961_(), 0);
        }
    }
}

