/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import party.lemons.biomemakeover.entity.TumbleweedEntity;
import party.lemons.biomemakeover.init.BMBlocks;

public class TumbleweedRender
extends EntityRenderer<TumbleweedEntity> {
    public TumbleweedRender(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TumbleweedEntity entity, float f, float delta, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        super.m_7392_((Entity)entity, f, delta, poseStack, multiBufferSource, i);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5, 0.0);
        poseStack.m_85845_(TumbleweedRender.slerp(entity.prevQuaternion, entity.quaternion, delta));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        poseStack.m_85837_(-0.5, -0.5, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        Minecraft.m_91087_().m_91289_().m_110912_(BMBlocks.TUMBLEWEED.get().m_49966_(), poseStack, multiBufferSource, i, OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }

    public static Quaternion slerp(Quaternion v0, Quaternion v1, float t) {
        float dot = v0.m_80140_() * v1.m_80140_() + v0.m_80150_() * v1.m_80150_() + v0.m_80153_() * v1.m_80153_() + v0.m_80156_() * v1.m_80156_();
        if (dot < 0.0f) {
            v1 = new Quaternion(-v1.m_80140_(), -v1.m_80150_(), -v1.m_80153_(), -v1.m_80156_());
            dot = -dot;
        }
        if (dot > 0.9995f) {
            float x = Mth.m_14179_((float)t, (float)v0.m_80140_(), (float)v1.m_80140_());
            float y = Mth.m_14179_((float)t, (float)v0.m_80150_(), (float)v1.m_80150_());
            float z = Mth.m_14179_((float)t, (float)v0.m_80153_(), (float)v1.m_80153_());
            float w = Mth.m_14179_((float)t, (float)v0.m_80156_(), (float)v1.m_80156_());
            return new Quaternion(x, y, z, w);
        }
        float angle01 = (float)Math.acos(dot);
        float angle0t = angle01 * t;
        float sin0t = Mth.m_14031_((float)angle0t);
        float sin01 = Mth.m_14031_((float)angle01);
        float sin1t = Mth.m_14031_((float)(angle01 - angle0t));
        float s1 = sin0t / sin01;
        float s0 = sin1t / sin01;
        return new Quaternion(s0 * v0.m_80140_() + s1 * v1.m_80140_(), s0 * v0.m_80150_() + s1 * v1.m_80150_(), s0 * v0.m_80153_() + s1 * v1.m_80153_(), s0 * v0.m_80156_() + s1 * v1.m_80156_());
    }

    public ResourceLocation getTextureLocation(TumbleweedEntity entity) {
        return TextureAtlas.f_118259_;
    }
}

