/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.HumanoidArm;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.RootlingEntity;
import party.lemons.biomemakeover.util.AnimationHelper;

public class RootlingModel
extends EntityModel<RootlingEntity>
implements HeadedModel,
ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(BiomeMakeover.ID("rootling"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart arm_right;
    private final ModelPart arm_left;
    private final ModelPart leg_right;
    private final ModelPart leg_left;

    public RootlingModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.arm_left = this.body.m_171324_("arm_left");
        this.arm_right = this.body.m_171324_("arm_right");
        this.leg_left = this.body.m_171324_("leg_left");
        this.leg_right = this.body.m_171324_("leg_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -2.5f, -3.5f, 7.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 12).m_171488_(-2.5f, -3.5f, -2.5f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(15, 12).m_171488_(-1.5f, 2.5f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)18.5f, (float)-0.5f));
        PartDefinition arm_right = body.m_171599_("arm_right", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, 0.0f, -1.5f, 1.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)-2.5f, (float)0.0f));
        PartDefinition arm_left = body.m_171599_("arm_left", CubeListBuilder.m_171558_().m_171514_(8, 18).m_171488_(0.0f, 0.0f, -1.5f, 1.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)-2.5f, (float)0.0f));
        PartDefinition leg_right = body.m_171599_("leg_right", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)3.0f, (float)0.0f));
        PartDefinition leg_left = body.m_171599_("leg_left", CubeListBuilder.m_171558_().m_171514_(3, 3).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)3.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(17, 17).m_171488_(-1.5f, -5.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(21, 0).m_171488_(-4.5f, -6.0f, -1.6f, 9.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)15.0f, (float)-0.5f));
        PartDefinition cube_r1 = head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(16, 25).m_171488_(-5.5f, -6.0f, 0.1f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-7.0f, (float)-1.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition cube_r2 = head.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(16, 25).m_171488_(-4.0607f, -8.0f, 0.0393f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(RootlingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        AnimationHelper.rotateHead(this.head, headPitch, netHeadYaw);
        AnimationHelper.swingLimb(this.arm_left, this.arm_right, limbSwing, limbSwingAmount, 1.4f);
        AnimationHelper.swingLimb(this.leg_left, this.leg_right, limbSwing, limbSwingAmount, 2.0f);
        this.body.f_104205_ = (float)(Math.sin(limbSwing) / 4.0) * limbSwingAmount;
        this.head.f_104205_ = (float)(Math.cos(limbSwing) / 8.0) * limbSwingAmount;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.head.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public void m_6002_(HumanoidArm humanoidArm, PoseStack poseStack) {
        this.getArm(humanoidArm).m_104299_(poseStack);
    }

    protected ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.arm_left : this.arm_right;
    }
}

