/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import party.lemons.biomemakeover.entity.BMBoatEntity;
import party.lemons.biomemakeover.util.registry.boat.BoatType;
import party.lemons.biomemakeover.util.registry.boat.BoatTypes;

public class BMBoatRender
extends EntityRenderer<BMBoatEntity> {
    private final Map<BoatType, Pair<ResourceLocation, BoatModel>> boatResources = Maps.newHashMap();
    private final Map<BoatType, ResourceLocation> textures = Maps.newHashMap();

    public BMBoatRender(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.8f;
        for (BoatType boatType : BoatTypes.TYPES) {
            this.boatResources.put(boatType, (Pair<ResourceLocation, BoatModel>)Pair.of((Object)boatType.getTexture(), (Object)new BoatModel(context.m_174023_(new ModelLayerLocation(new ResourceLocation("biomemakeover", boatType.getModelLocation()), "main")))));
        }
    }

    public void render(BMBoatEntity boat, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        float k;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.375, 0.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - f));
        float h = (float)boat.m_38385_() - g;
        float j = boat.m_38384_() - g;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)h) * h * j / 10.0f * (float)boat.m_38386_()));
        }
        if (!Mth.m_14033_((float)(k = boat.m_38352_(g)), (float)0.0f)) {
            poseStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), boat.m_38352_(g), true));
        }
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        Pair<ResourceLocation, BoatModel> data = this.boatResources.get(boat.getNewBoatType());
        BoatModel model = (BoatModel)data.getSecond();
        ResourceLocation texture = (ResourceLocation)data.getFirst();
        model.m_6973_((Boat)boat, g, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(model.m_103119_(texture));
        model.m_7695_(poseStack, vertexConsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer vertexConsumer2 = multiBufferSource.m_6299_(RenderType.m_110478_());
            model.m_102282_().m_104301_(poseStack, vertexConsumer2, i, OverlayTexture.f_118083_);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)boat, f, g, poseStack, multiBufferSource, i);
    }

    public ResourceLocation getTextureLocation(BMBoatEntity entity) {
        BoatType type = entity.getNewBoatType();
        if (this.textures.containsKey(type)) {
            return this.textures.get(type);
        }
        ResourceLocation texture = type.getTexture();
        this.textures.put(type, texture);
        return texture;
    }
}

