/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.event;

import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.util.RandomUtil;

public enum EntityEvent {
    BONEMEAL_PARTICLE(e -> EntityEvent.entityParticles(e, ParticleTypes.f_123748_, 15, 0.02f, 0.0, 0.0, 0.0)),
    ENDER_PARTICLES(e -> EntityEvent.entityParticles(e, ParticleTypes.f_123760_, 10, 0.5f, e.f_19853_.f_46441_.nextDouble() - 0.5, -e.f_19853_.f_46441_.nextDouble(), (e.f_19853_.f_46441_.nextDouble() - 0.5) * 2.0)),
    TELEPORT_PARTICLES(e -> EntityEvent.centeredEntityParticles(e, (SimpleParticleType)BMEffects.TELEPORT.get(), 10, true, e.f_19853_.f_46441_.nextGaussian() * 0.02, e.f_19853_.f_46441_.nextGaussian() * 0.02, e.f_19853_.f_46441_.nextGaussian() * 0.02));

    private final Consumer<Entity> behaviour;

    private static void centeredEntityParticles(Entity entity, SimpleParticleType particle, int count, boolean varyY, double vX, double vY, double vZ) {
        for (int i = 0; i < count; ++i) {
            AABB bb = entity.m_142469_();
            double xx = bb.m_82399_().f_82479_;
            double zz = bb.m_82399_().f_82481_;
            double yy = varyY ? RandomUtil.randomRange(bb.f_82289_, bb.f_82292_) : bb.f_82289_;
            entity.m_183503_().m_7106_((ParticleOptions)particle, xx, yy, xx, vX, vY, vZ);
        }
    }

    private static void entityParticles(Entity entity, SimpleParticleType particle, int count, float offset, double vX, double vY, double vZ) {
        for (int i = 0; i < count; ++i) {
            entity.m_183503_().m_7106_((ParticleOptions)particle, entity.m_20208_((double)offset), entity.m_20187_(), entity.m_20262_((double)offset), vX, vY, vZ);
        }
    }

    private static void enderParticles(Entity entity) {
        for (int i = 0; i < 10; ++i) {
            entity.m_183503_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, entity.m_20208_(0.5), entity.m_20187_(), entity.m_20262_(0.5), (entity.f_19853_.f_46441_.nextDouble() - 0.5) * 2.0, -entity.f_19853_.f_46441_.nextDouble(), (entity.f_19853_.f_46441_.nextDouble() - 0.5) * 2.0);
        }
    }

    private static void entityBonemeal(Entity entity) {
        entity.m_183503_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.0, 0.0, 0.0);
        for (int i = 0; i < 15; ++i) {
            double xx = entity.m_20208_(0.02);
            double yy = entity.m_20187_();
            double zz = entity.m_20262_(0.02);
            entity.m_183503_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, xx, yy, zz, 0.0, 0.0, 0.0);
        }
    }

    private EntityEvent(Consumer<Entity> behaviour) {
        this.behaviour = behaviour;
    }

    public void execute(Entity entity) {
        this.behaviour.accept(entity);
    }
}

