/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3d;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.level.WindSystem;

public class TumbleweedEntity
extends Entity {
    public Quaternion quaternion = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    public Quaternion prevQuaternion = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    private Vector3d prevVelocity;
    private float xRot = 0.0f;
    private float zRot = 0.0f;
    private double disX = 0.0;
    private double disZ = 0.0;
    private float windOffset = 0.0f;
    private final float acceleration = 0.0025f;
    private float age = 0.0f;
    private int stuckX;
    private int stuckZ;
    private int staticTime;

    public TumbleweedEntity(EntityType<? extends TumbleweedEntity> type, Level level) {
        super(type, level);
        this.windOffset = 1.0f - level.m_5822_().nextFloat() / 3.0f;
    }

    public void m_8119_() {
        this.age += 1.0f;
        if (this.age > 1500.0f) {
            this.m_6074_();
        }
        if (!this.m_20069_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        super.m_8119_();
        this.prevQuaternion = new Quaternion(this.quaternion);
        this.prevVelocity = new Vector3d(this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
        double pX = this.m_20185_();
        double pZ = this.m_20189_();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        double fX = this.m_20185_();
        double fZ = this.m_20189_();
        this.disX = fX - pX;
        this.disZ = fZ - pZ;
        double vX = 0.0;
        double vY = 0.0;
        double vZ = 0.0;
        if (!this.f_19853_.m_5776_()) {
            vX = this.step(this.m_20184_().m_7096_(), WindSystem.windX * this.windOffset, 0.0025f);
            vZ = this.step(this.m_20184_().m_7094_(), WindSystem.windZ * this.windOffset, 0.0025f);
            vY = this.m_20184_().m_7098_();
            if (this.f_19861_) {
                vY = Mth.m_14008_((double)(Math.abs(this.prevVelocity.f_86215_) * 0.75), (double)0.31f, (double)2.0);
                this.m_5496_(BMEffects.TUMBLEWEED_TUMBLE.get(), 0.25f, 1.0f);
            }
            if (this.m_20069_()) {
                vX *= 0.75;
                vZ *= 0.75;
                vY = 0.1f;
            }
        } else {
            if (this.f_19861_) {
                this.makeParticles(15);
                this.xRot = (float)(-(this.disX / 0.25));
                this.zRot = (float)(this.disZ / 0.25);
            } else {
                this.xRot = (float)(-(this.disX / 0.6));
                this.zRot = (float)(this.disZ / 0.6);
            }
            Quaternion rot = new Quaternion(this.zRot, 0.0f, this.xRot, false);
            rot.m_80148_(this.quaternion);
            this.quaternion = rot;
        }
        if (!this.f_19853_.m_5776_()) {
            this.m_20334_(vX, vY, vZ);
            this.f_19812_ = true;
            this.f_19864_ = true;
        }
        if ((int)this.m_20185_() == this.stuckX && (int)this.m_20189_() == this.stuckZ) {
            ++this.staticTime;
            if (this.staticTime >= 100) {
                this.m_6074_();
            }
        } else {
            this.staticTime = 0;
        }
        this.stuckX = (int)this.m_20185_();
        this.stuckZ = (int)this.m_20189_();
    }

    public void m_6074_() {
        this.makeParticles(30);
        super.m_6074_();
    }

    protected void m_8097_() {
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (damageSource != DamageSource.f_19314_) {
            this.m_5496_(BMEffects.TUMBLEWEED_BREAK.get(), 0.25f, 1.0f);
            this.m_6074_();
        }
        return true;
    }

    private void makeParticles(int count) {
        for (int i = 0; i < count; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, BMBlocks.TUMBLEWEED.get().m_49966_()), -0.5 + (this.m_20185_() + this.f_19796_.nextDouble()), this.m_20186_() + this.f_19796_.nextDouble(), -0.5 + (this.m_20189_() + this.f_19796_.nextDouble()), 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_7378_(CompoundTag compoundTag) {
    }

    protected void m_7380_(CompoundTag compoundTag) {
    }

    public boolean m_6087_() {
        return !this.m_146910_();
    }

    public boolean m_7337_(Entity entity) {
        return true;
    }

    public Packet<?> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    private double step(double val, double target, double step) {
        if (val < target) {
            return Math.min(val + step, target);
        }
        return Math.max(val - step, target);
    }
}

