/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.entity.event.EntityEvent;
import party.lemons.biomemakeover.entity.event.EntityEventBroadcaster;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.util.EntityUtil;
import party.lemons.biomemakeover.util.RandomUtil;

public class RootlingEntity
extends Animal
implements Shearable,
EntityEventBroadcaster {
    public static final EntityDataAccessor<Boolean> HAS_FLOWER = SynchedEntityData.m_135353_(RootlingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> FLOWER_TYPE = SynchedEntityData.m_135353_(RootlingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Supplier<Item>[] PETAL_ITEMS = new Supplier[]{BMItems.BLUE_PETALS, BMItems.BROWN_PETALS, BMItems.CYAN_PETALS, BMItems.GRAY_PETALS, BMItems.LIGHT_BLUE_PETALS, BMItems.PURPLE_PETALS};
    private boolean hasAction = false;
    public RootlingEntity forcedDancePartner = null;
    private int actionCooldown = RandomUtil.randomRange(0, 500);
    private int growTime = 0;
    private static final TargetingConditions VALID_ROOTLING_PARTNER = TargetingConditions.m_148353_().m_26883_(8.0);
    public static int MAX_DANCE_TIME = 60;
    public static int MAX_FOLLOW_TIME = 120;
    public static int MAX_INSPECT_TIME = 200;
    public static int MAX_ACTION_COOLDOWN = 500;

    public RootlingEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new GetInRainGoal());
        this.f_21345_.m_25352_(4, (Goal)new RootlingFleeGoal((PathfinderMob)this, LivingEntity.class, 8.0f, 1.6, 1.4, e -> e.m_6844_(EquipmentSlot.MAINHAND).m_41720_() == Items.f_42574_ || e.m_6844_(EquipmentSlot.OFFHAND).m_41720_() == Items.f_42574_));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42499_}), false));
        this.f_21345_.m_25352_(6, (Goal)new DanceGoal());
        this.f_21345_.m_25352_(7, (Goal)new FollowEntityGoal());
        this.f_21345_.m_25352_(8, (Goal)new InspectFlowerGoal());
        this.f_21345_.m_25352_(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(HAS_FLOWER, (Object)true);
        this.m_20088_().m_135372_(FLOWER_TYPE, (Object)0);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!this.f_19853_.m_5776_()) {
            if (!this.hasAction()) {
                --this.actionCooldown;
            }
            if (this.growTime > 0) {
                --this.growTime;
                if (this.m_20069_() && this.f_19796_.nextInt(5) == 0) {
                    --this.growTime;
                }
                if (this.growTime <= 0 && !this.hasFlower()) {
                    this.setFlowered(true);
                }
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return RootlingEntity.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41720_() == Items.f_42574_) {
            if (!this.f_19853_.m_5776_() && this.m_6220_()) {
                this.m_5851_(SoundSource.PLAYERS);
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (itemStack.m_41720_() == Items.f_42499_ && !this.hasFlower()) {
            if (this.f_19853_.m_5776_()) {
                return InteractionResult.CONSUME;
            }
            this.broadcastEvent((Entity)this, EntityEvent.BONEMEAL_PARTICLE);
            if (this.f_19796_.nextInt(3) == 0) {
                this.setFlowered(true);
            }
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public int getActionCooldown() {
        return this.actionCooldown;
    }

    public void setActionCoolDown(int cooldown) {
        this.actionCooldown = cooldown;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("ActionCooldown", this.actionCooldown);
        tag.m_128405_("GrowTime", this.growTime);
        tag.m_128379_("HasFlower", ((Boolean)this.m_20088_().m_135370_(HAS_FLOWER)).booleanValue());
        tag.m_128405_("FlowerType", this.getFlowerIndex());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.actionCooldown = tag.m_128451_("ActionCooldown");
        this.growTime = tag.m_128451_("GrowTime");
        this.m_20088_().m_135381_(HAS_FLOWER, (Object)tag.m_128471_("HasFlower"));
        this.m_20088_().m_135381_(FLOWER_TYPE, (Object)tag.m_128451_("FlowerType"));
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return this.m_6972_((Pose)this.m_20089_()).f_20378_ * 0.6f;
    }

    public boolean hasFlower() {
        return (Boolean)this.m_20088_().m_135370_(HAS_FLOWER);
    }

    public void setFlowered(boolean hasFlower) {
        boolean current = (Boolean)this.m_20088_().m_135370_(HAS_FLOWER);
        if (current != hasFlower) {
            this.m_20088_().m_135381_(HAS_FLOWER, (Object)hasFlower);
            if (hasFlower) {
                this.randomizeFlower();
            } else {
                EntityUtil.scatterItemStack((Entity)this, new ItemStack((ItemLike)PETAL_ITEMS[(Integer)this.m_20088_().m_135370_(FLOWER_TYPE)].get(), RandomUtil.randomRange(1, 4)));
            }
        }
    }

    public boolean hasAction() {
        return this.hasAction;
    }

    public void setHasAction(boolean dancing) {
        this.hasAction = dancing;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public void m_5851_(SoundSource soundSource) {
        this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12344_, soundSource, 1.0f, 1.0f);
        this.setFlowered(false);
        this.growTime = RandomUtil.randomRange(600, 1200);
    }

    public boolean m_6220_() {
        return this.hasFlower();
    }

    public int getFlowerIndex() {
        return (Integer)this.m_20088_().m_135370_(FLOWER_TYPE);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        SpawnGroupData data = super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
        this.randomizeFlower();
        return data;
    }

    public void randomizeFlower() {
        this.m_20088_().m_135381_(FLOWER_TYPE, (Object)this.f_19796_.nextInt(PETAL_ITEMS.length));
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return BMEffects.ROOTLING_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return BMEffects.ROOTLING_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return BMEffects.ROOTLING_IDLE.get();
    }

    public class GetInRainGoal
    extends Goal {
        private double targetX;
        private double targetY;
        private double targetZ;

        public GetInRainGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (RootlingEntity.this.f_19853_.m_46471_() && !RootlingEntity.this.f_19853_.m_45527_(RootlingEntity.this.m_20097_())) {
                return true;
            }
            return this.targetSkyPos();
        }

        protected boolean targetSkyPos() {
            Vec3 vec3d = this.locateSkyPos();
            if (vec3d == null) {
                return false;
            }
            this.targetX = vec3d.f_82479_;
            this.targetY = vec3d.f_82480_;
            this.targetZ = vec3d.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !RootlingEntity.this.m_21573_().m_26571_();
        }

        public void m_8056_() {
            RootlingEntity.this.m_21573_().m_26519_(this.targetX, this.targetY, this.targetZ, 1.0);
        }

        protected Vec3 locateSkyPos() {
            Random random = RootlingEntity.this.m_21187_();
            BlockPos blockPos = RootlingEntity.this.m_20097_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockPos2 = blockPos.m_142082_(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
                if (!RootlingEntity.this.f_19853_.m_45527_(blockPos2) || !(RootlingEntity.this.m_21692_(blockPos2) < 0.0f)) continue;
                return Vec3.m_82539_((Vec3i)blockPos2);
            }
            return null;
        }
    }

    private class RootlingFleeGoal
    extends AvoidEntityGoal<LivingEntity> {
        private int soundTime;
        private final TargetingConditions withinRangePredicate;

        public RootlingFleeGoal(PathfinderMob fleeingEntity, Class<LivingEntity> classToFleeFrom, float fleeDistance, double fleeSlowSpeed, double fleeFastSpeed, Predicate<LivingEntity> inclusionSelector) {
            super(fleeingEntity, classToFleeFrom, fleeDistance, fleeSlowSpeed, fleeFastSpeed, inclusionSelector);
            this.soundTime = 0;
            this.withinRangePredicate = TargetingConditions.m_148353_().m_26883_((double)fleeDistance).m_26888_(inclusionSelector.and(inclusionSelector));
        }

        public boolean m_8036_() {
            this.f_25016_ = this.f_25015_.f_19853_.m_45963_(this.f_25020_, this.withinRangePredicate, (LivingEntity)this.f_25015_, this.f_25015_.m_20185_(), this.f_25015_.m_20186_(), this.f_25015_.m_20189_(), this.f_25015_.m_142469_().m_82377_((double)this.f_25017_, 3.0, (double)this.f_25017_));
            if (this.f_25016_ == null) {
                return false;
            }
            Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.f_25015_, (int)16, (int)7, (Vec3)this.f_25016_.m_20182_());
            if (vec3 == null) {
                return false;
            }
            if (this.f_25016_.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.f_25016_.m_20280_((Entity)this.f_25015_)) {
                return false;
            }
            this.f_25018_ = this.f_25019_.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
            return this.f_25018_ != null;
        }

        public void m_8056_() {
            super.m_8056_();
            if (this.soundTime == 0) {
                this.f_25015_.m_5496_(BMEffects.ROOTLING_AFRAID.get(), 1.0f, 1.0f + RootlingEntity.this.f_19796_.nextFloat() / 10.0f);
            }
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.soundTime;
            if (this.soundTime > 100) {
                this.f_25015_.m_5496_(BMEffects.ROOTLING_AFRAID.get(), 1.0f, 1.0f + RootlingEntity.this.f_19796_.nextFloat() / 10.0f);
                this.soundTime = 0;
            }
        }
    }

    public class DanceGoal
    extends Goal {
        private RootlingEntity partner = null;
        private int timer;

        public DanceGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (RootlingEntity.this.forcedDancePartner != null) {
                this.partner = RootlingEntity.this.forcedDancePartner;
                RootlingEntity.this.forcedDancePartner = null;
                return true;
            }
            if (RootlingEntity.this.hasAction() || RootlingEntity.this.getActionCooldown() >= 0) {
                return false;
            }
            this.partner = this.findPartner();
            return this.partner != null;
        }

        public boolean m_8045_() {
            return this.partner.m_6084_() && this.partner.hasAction() && this.timer < MAX_DANCE_TIME;
        }

        public void m_8041_() {
            this.partner = null;
            this.timer = 0;
            RootlingEntity.this.setHasAction(false);
            if (this.partner != null) {
                this.partner.setHasAction(false);
            }
        }

        public void m_8056_() {
            RootlingEntity.this.setHasAction(true);
            this.partner.setHasAction(true);
            RootlingEntity.this.setActionCoolDown(MAX_ACTION_COOLDOWN);
        }

        private RootlingEntity findPartner() {
            List list = RootlingEntity.this.f_19853_.m_45971_(RootlingEntity.class, VALID_ROOTLING_PARTNER, (LivingEntity)RootlingEntity.this, RootlingEntity.this.m_142469_().m_82400_(8.0));
            double minDistance = Double.MAX_VALUE;
            RootlingEntity closestPossible = null;
            for (RootlingEntity rootlingEntity : list) {
                if (rootlingEntity.hasAction() || rootlingEntity.getActionCooldown() > 0 || !(RootlingEntity.this.m_20280_((Entity)rootlingEntity) < minDistance)) continue;
                closestPossible = rootlingEntity;
                minDistance = RootlingEntity.this.m_20280_((Entity)rootlingEntity);
            }
            if (closestPossible != null) {
                closestPossible.forcedDancePartner = RootlingEntity.this;
            }
            return closestPossible;
        }

        public void m_8037_() {
            RootlingEntity.this.m_21563_().m_24960_((Entity)this.partner, 10.0f, (float)RootlingEntity.this.m_8132_());
            RootlingEntity.this.m_21573_().m_5624_((Entity)this.partner, 1.0);
            ++this.timer;
            if (this.timer < MAX_DANCE_TIME && RootlingEntity.this.m_20280_((Entity)this.partner) < 9.0) {
                RootlingEntity.this.m_21569_().m_24901_();
            }
        }
    }

    public class FollowEntityGoal
    extends Goal {
        public LivingEntity followPartner;
        private int timer = 0;

        public FollowEntityGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (RootlingEntity.this.hasAction() || RootlingEntity.this.getActionCooldown() >= 0 || RootlingEntity.this.f_19796_.nextInt(10) != 0) {
                return false;
            }
            this.followPartner = this.findFollowPartner();
            return this.followPartner != null;
        }

        public boolean m_8045_() {
            return this.followPartner.m_6084_() && this.timer < MAX_FOLLOW_TIME;
        }

        public void m_8041_() {
            this.followPartner = null;
            this.timer = 0;
            RootlingEntity.this.setHasAction(false);
        }

        public void m_8056_() {
            RootlingEntity.this.setHasAction(true);
            RootlingEntity.this.setActionCoolDown(MAX_ACTION_COOLDOWN);
        }

        public void m_8037_() {
            RootlingEntity.this.m_21563_().m_24960_((Entity)this.followPartner, 10.0f, (float)RootlingEntity.this.m_8132_());
            RootlingEntity.this.m_21573_().m_5624_((Entity)this.followPartner, 1.0);
            if (RootlingEntity.this.m_20280_((Entity)this.followPartner) <= 4.0) {
                RootlingEntity.this.m_21573_().m_26573_();
            }
            ++this.timer;
        }

        private LivingEntity findFollowPartner() {
            List list = RootlingEntity.this.f_19853_.m_45971_(Animal.class, VALID_ROOTLING_PARTNER, (LivingEntity)RootlingEntity.this, RootlingEntity.this.m_142469_().m_82400_(8.0));
            double minDistance = Double.MAX_VALUE;
            Animal closestPossible = null;
            for (Animal e : list) {
                if (!(RootlingEntity.this.m_20280_((Entity)e) < minDistance) || e instanceof RootlingEntity) continue;
                closestPossible = e;
                minDistance = RootlingEntity.this.m_20280_((Entity)e);
            }
            return closestPossible;
        }
    }

    public class InspectFlowerGoal
    extends Goal {
        private BlockPos targetPos;
        private BlockState targetState;
        private int timer;

        public InspectFlowerGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (RootlingEntity.this.f_19796_.nextInt(10) == 0 || RootlingEntity.this.actionCooldown > 0 || RootlingEntity.this.hasAction()) {
                return false;
            }
            this.targetPos = this.findFlower();
            return this.targetPos != null;
        }

        public void m_8037_() {
            ++this.timer;
            if (RootlingEntity.this.m_20275_((float)this.targetPos.m_123341_() + 0.5f, (float)this.targetPos.m_123342_() + 0.5f, (float)this.targetPos.m_123343_() + 0.5f) > 2.0) {
                RootlingEntity.this.m_21566_().m_6849_((double)((float)this.targetPos.m_123341_() + 0.5f), (double)((float)this.targetPos.m_123342_() + 0.5f), (double)((float)this.targetPos.m_123343_() + 0.5f), (double)0.6f);
            }
            float targetY = this.targetPos.m_123342_();
            if (this.targetState.m_204336_(BlockTags.f_13040_)) {
                targetY += 1.0f;
            }
            RootlingEntity.this.m_21563_().m_24946_((double)((float)this.targetPos.m_123341_() + 0.5f), (double)targetY, (double)((float)this.targetPos.m_123343_() + 0.5f));
        }

        public boolean m_8045_() {
            BlockState st = RootlingEntity.this.f_19853_.m_8055_(this.targetPos);
            if (st != this.targetState) {
                return false;
            }
            return this.timer <= MAX_INSPECT_TIME;
        }

        public void m_8041_() {
            this.timer = 0;
            RootlingEntity.this.setHasAction(false);
        }

        public void m_8056_() {
            RootlingEntity.this.setHasAction(true);
            RootlingEntity.this.setActionCoolDown(MAX_ACTION_COOLDOWN);
        }

        private BlockPos findFlower() {
            BlockPos startPos = RootlingEntity.this.m_20097_();
            ArrayList spots = Lists.newArrayList();
            BlockPos.MutableBlockPos m = new BlockPos.MutableBlockPos(startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_());
            for (int x = startPos.m_123341_() - 2; x < startPos.m_123341_() + 2; ++x) {
                for (int z = startPos.m_123343_() - 2; z < startPos.m_123343_() + 2; ++z) {
                    m.m_122178_(x, startPos.m_123342_(), z);
                    BlockState checkState = RootlingEntity.this.f_19853_.m_8055_((BlockPos)m);
                    if (!checkState.m_204336_(BlockTags.f_13041_)) continue;
                    spots.add(new BlockPos(m.m_123341_(), m.m_123342_(), m.m_123343_()));
                }
            }
            if (spots.isEmpty()) {
                return null;
            }
            BlockPos pos = (BlockPos)spots.get(RootlingEntity.this.f_19853_.f_46441_.nextInt(spots.size()));
            if (pos != null) {
                this.targetState = RootlingEntity.this.f_19853_.m_8055_(pos);
            }
            return pos;
        }
    }
}

