/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.crafting.witch.QuestRarity;
import party.lemons.biomemakeover.crafting.witch.WitchQuest;
import party.lemons.biomemakeover.crafting.witch.WitchQuestList;
import party.lemons.biomemakeover.crafting.witch.menu.WitchMenu;
import party.lemons.biomemakeover.network.C2S_HandleCompleteQuest;

public class WitchScreen
extends AbstractContainerScreen<WitchMenu> {
    private static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/gui/witch.png");
    private static final Component QUESTS_TEXT = new TranslatableComponent("witch.quests");
    private static final Component SEPARATOR = new TextComponent(" - ");
    private static final Component DEPRECATED_TEXT = new TranslatableComponent("merchant.deprecated");
    private final QuestButton[] questButtons = new QuestButton[3];
    private final Inventory inventory;

    public WitchScreen(WitchMenu handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.f_97726_ = 174;
        this.f_97727_ = 181;
        this.f_97730_ = 110;
        this.f_97731_ = this.f_97727_ - 92;
        this.inventory = inventory;
    }

    private void clickQuest(int index, WitchQuest quest) {
        if (quest.hasItems((Container)this.f_96541_.f_91074_.m_150109_())) {
            new C2S_HandleCompleteQuest(index).sendToServer();
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.updateQuests();
    }

    protected void updateQuests() {
        for (int i = 0; i < this.questButtons.length; ++i) {
            this.m_169411_((GuiEventListener)this.questButtons[i]);
            this.questButtons[i] = null;
        }
        int xx = 3 + (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        int yy = j + 16 + 2;
        WitchQuestList quests = ((WitchMenu)this.m_6262_()).getQuests();
        for (int i = 0; i < quests.size(); ++i) {
            int index = i;
            this.questButtons[i] = (QuestButton)this.m_142416_((GuiEventListener)new QuestButton(xx, yy + i * 26, (WitchQuest)quests.get(index), b -> this.clickQuest(index, (WitchQuest)quests.get(index))));
        }
    }

    protected void m_7027_(PoseStack matrices, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(matrices, this.f_96539_, (float)(49 + this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), 6.0f, 0x404040);
        this.f_96547_.m_92889_(matrices, this.inventory.m_5446_(), (float)this.f_97730_, (float)this.f_97731_, 0x404040);
        int l = this.f_96547_.m_92852_((FormattedText)QUESTS_TEXT);
        this.f_96547_.m_92889_(matrices, QUESTS_TEXT, (float)(5 - l / 2 + 48), 6.0f, 0x404040);
    }

    protected void m_7286_(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        MerchantScreen.m_93143_((PoseStack)matrices, (int)k, (int)l, (int)this.m_93252_(), (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)512, (int)256);
        WitchQuestList tradeOfferList = ((WitchMenu)this.m_6262_()).getQuests();
        if (!tradeOfferList.isEmpty()) {
            // empty if block
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        this.m_7025_(matrices, mouseX, mouseY);
        for (QuestButton questButton : this.questButtons) {
            if (questButton == null || !questButton.m_198029_()) continue;
            questButton.m_7428_(matrices, mouseX, mouseY);
        }
    }

    class QuestButton
    extends Button {
        private final WitchQuest quest;
        private final QuestRarity questRarity;

        public QuestButton(int x, int y, WitchQuest quest, Button.OnPress action) {
            super(x, y, 104, 26, TextComponent.f_131282_, action);
            this.quest = quest;
            this.questRarity = QuestRarity.getRarityFromQuest(quest);
        }

        public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            int drawTextureIndex = 1;
            if (this.quest.hasItems((Container)Minecraft.m_91087_().f_91074_.m_150109_())) {
                ++drawTextureIndex;
                if (this.m_198029_()) {
                    ++drawTextureIndex;
                }
            }
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            QuestButton.m_93133_((PoseStack)matrices, (int)this.f_93620_, (int)this.f_93621_, (float)174.0f, (float)(drawTextureIndex * 26), (int)this.f_93618_, (int)this.f_93619_, (int)512, (int)256);
            int rarityY = 7 + this.questRarity.ordinal() * 5;
            QuestButton.m_93133_((PoseStack)matrices, (int)(this.f_93620_ + 4), (int)(this.f_93621_ + 11), (float)278.0f, (float)rarityY, (int)5, (int)5, (int)512, (int)256);
            int itemXX = this.f_93620_ + 11;
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            for (ItemStack stack : this.quest.getRequiredItems()) {
                this.m_93250_(200);
                itemRenderer.f_115093_ = 200.0f;
                itemRenderer.m_115203_(stack, itemXX, this.f_93621_ + 5);
                itemRenderer.m_115174_(((WitchScreen)WitchScreen.this).f_96541_.f_91062_, stack, itemXX, this.f_93621_ + 5, String.valueOf(stack.m_41613_()));
                itemXX += 18;
            }
            this.m_93250_(0);
            itemRenderer.f_115093_ = 0.0f;
        }

        public void m_7428_(PoseStack matrices, int mouseX, int mouseY) {
            int xx = mouseX - this.f_93620_;
            int yy = mouseY - this.f_93621_;
            if (this.m_198029_() && xx > 5 && yy < 19) {
                int index;
                if (xx > 2 && xx < 9) {
                    WitchScreen.this.m_96602_(matrices, this.questRarity.getTooltipText(), mouseX, mouseY);
                }
                if (xx > 11 && (index = (xx -= 11) / 18) < this.quest.getRequiredItems().length) {
                    int bgX = this.f_93620_ + 11 + index * 18;
                    int bgY = this.f_93621_ + 5;
                    RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                    this.m_93179_(matrices, bgX, bgY, bgX + 16, bgY + 16, -2130706433, -2130706433);
                    RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    WitchScreen.this.m_6057_(matrices, this.quest.getRequiredItems()[index], mouseX, mouseY);
                }
            }
        }
    }
}

