/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.mixins.basic.server.mc224729;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import dev.isxander.debugify.lib.mixinextras.injector.ModifyExpressionValue;
import java.util.function.Predicate;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@BugFix(id="MC-224729", category=FixCategory.BASIC, env=BugFix.Env.SERVER, fabricConflicts={"chunksavingfix"})
@Mixin(value={ChunkMap.class})
public class ThreadedAnvilChunkStorageMixin {
    @ModifyArg(method={"save(Z)V"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;", ordinal=0))
    private Predicate<ChunkHolder> alwaysAccessibleFlushSave(Predicate<ChunkHolder> predicate) {
        return chunkHolder -> true;
    }

    @ModifyArg(method={"save(Z)V"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;", ordinal=1))
    private Predicate<ChunkAccess> saveProtoChunks(Predicate<ChunkAccess> predicate) {
        return c -> predicate.test((ChunkAccess)c) || c instanceof ProtoChunk;
    }

    @ModifyExpressionValue(method={"save(Lnet/minecraft/server/world/ChunkHolder;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ChunkHolder;isAccessible()Z")})
    private boolean alwaysAccessibleChunkSave(boolean accessible) {
        return true;
    }
}

