/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.client.utils;

import dev.isxander.debugify.client.DebugifyClient;
import dev.isxander.debugify.config.DebugifyConfig;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.BugFixData;
import dev.isxander.debugify.fixes.FixCategory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ConfigGuiHelper {
    public static Screen createConfigGui(DebugifyConfig config, Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setTitle((Component)new TextComponent("Debugify")).setSavingRunnable(config::save).setParentScreen(parent);
        HashMap<FixCategory, ConfigCategory> fixCategories = new HashMap<FixCategory, ConfigCategory>();
        HashMap<ConfigCategory, Map> fixSubCategories = new HashMap<ConfigCategory, Map>();
        for (FixCategory fixCategory : FixCategory.values()) {
            ConfigCategory configCategory = builder.getOrCreateCategory((Component)new TextComponent(fixCategory.getDisplayName()));
            if (fixCategory == FixCategory.GAMEPLAY) {
                configCategory.addEntry((AbstractConfigListEntry)builder.entryBuilder().startTextDescription((Component)new TextComponent("WARNING: This category contains fixes that may be an unfair advantage!").m_130940_(ChatFormatting.RED)).build());
                configCategory.addEntry((AbstractConfigListEntry)builder.entryBuilder().startBooleanToggle((Component)new TextComponent("Enable In Multiplayer"), config.gameplayFixesInMultiplayer).setSaveConsumer(enabled -> {
                    config.gameplayFixesInMultiplayer = enabled;
                }).build());
            }
            fixCategories.put(fixCategory, configCategory);
            HashMap<BugFix.Env, SubCategoryBuilder> subCategories2 = new HashMap<BugFix.Env, SubCategoryBuilder>();
            for (BugFix.Env env : BugFix.Env.values()) {
                SubCategoryBuilder subCategoryBuilder = builder.entryBuilder().startSubCategory((Component)new TextComponent(env.getDisplayName()));
                subCategories2.put(env, subCategoryBuilder);
            }
            fixSubCategories.put(configCategory, subCategories2);
        }
        config.getBugFixes().forEach((bug, enabled) -> {
            SubCategoryBuilder subcategory = (SubCategoryBuilder)((Map)fixSubCategories.get(fixCategories.get((Object)bug.category()))).get((Object)bug.env());
            BooleanToggleBuilder entry = builder.entryBuilder().startBooleanToggle((Component)new TextComponent(bug.bugId()), enabled.booleanValue()).setSaveConsumer(toggled -> config.getBugFixes().replace((BugFixData)bug, (Boolean)toggled)).setDefaultValue(true).setErrorSupplier(b -> {
                List<String> conflicts = bug.getActiveConflicts();
                if (!b.booleanValue() || conflicts.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(new TextComponent(bug.bugId() + " is conflicting with " + (String)(conflicts.size() == 1 ? conflicts.get(0) : "mods " + String.join((CharSequence)", ", conflicts))));
            }).requireRestart();
            if (DebugifyClient.bugFixDescriptionCache.has(bug.bugId())) {
                entry.setTooltip(new Component[]{new TextComponent(DebugifyClient.bugFixDescriptionCache.get(bug.bugId()))});
            }
            subcategory.add((AbstractConfigListEntry)entry.build());
        });
        fixSubCategories.forEach((category, subCategories) -> subCategories.forEach((env, subCategoryBuilder) -> category.addEntry((AbstractConfigListEntry)subCategoryBuilder.build())));
        ConfigCategory miscCategory = builder.getOrCreateCategory((Component)new TextComponent("Misc"));
        BooleanListEntry optOutUpdaterEntry = builder.entryBuilder().startBooleanToggle((Component)new TextComponent("Opt Out Updater"), config.optOutUpdater).setTooltip(new Component[]{new TextComponent("Stop Debugify checking for updates on launch.")}).setSaveConsumer(toggled -> {
            config.optOutUpdater = toggled;
        }).setDefaultValue(false).build();
        miscCategory.addEntry((AbstractConfigListEntry)optOutUpdaterEntry);
        BooleanListEntry defaultDisabledEntry = builder.entryBuilder().startBooleanToggle((Component)new TextComponent("Default to Disabled"), config.defaultDisabled).setTooltip(new Component[]{new TextComponent("Default new bug fixes to be disabled rather than enabled.")}).setSaveConsumer(toggled -> {
            config.defaultDisabled = toggled;
        }).setDefaultValue(false).build();
        miscCategory.addEntry((AbstractConfigListEntry)defaultDisabledEntry);
        return builder.build();
    }
}

