/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.text2speech.Narrator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.awt.Rectangle;
import java.util.function.Supplier;
import mcp.mobius.waila.access.DataAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.EmptyComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.event.EventCanceller;
import mcp.mobius.waila.gui.hud.Line;
import mcp.mobius.waila.gui.hud.Tooltip;
import mcp.mobius.waila.mixin.BossHealthOverlayAccess;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;

public class TooltipRenderer {
    private static final Tooltip TOOLTIP = new Tooltip();
    private static final Supplier<Rectangle> RENDER_RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Rectangle> RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Narrator> NARRATOR = Suppliers.memoize(Narrator::getNarrator);
    private static boolean started;
    private static String lastNarration;
    private static ITooltipComponent icon;
    private static int topOffset;
    private static int maxLineWidth;
    public static int colonOffset;
    public static int colonWidth;
    public static State state;

    public static void beginBuild(State state) {
        started = true;
        TooltipRenderer.state = state;
        TOOLTIP.clear();
        icon = EmptyComponent.INSTANCE;
        topOffset = 0;
        maxLineWidth = 0;
        colonOffset = 0;
        colonWidth = Minecraft.m_91087_().f_91062_.m_92895_(": ");
    }

    public static void add(Tooltip tooltip) {
        for (Component component : tooltip) {
            if (component instanceof Line) {
                Line line = (Line)component;
                if (line.tag != null) {
                    TOOLTIP.setLine(line.tag, line);
                    continue;
                }
                TooltipRenderer.add(line);
                continue;
            }
            TooltipRenderer.add(new Line(null).with(component));
        }
    }

    public static void add(Line line) {
        Preconditions.checkState((boolean)started);
        TOOLTIP.add(line);
        for (ITooltipComponent component : line.components) {
            if (!(component instanceof PairComponent)) continue;
            PairComponent pair = (PairComponent)component;
            colonOffset = Math.max(pair.key.getWidth(), colonOffset);
            break;
        }
    }

    public static void setIcon(ITooltipComponent icon) {
        Preconditions.checkState((boolean)started);
        TooltipRenderer.icon = PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_ICON) ? icon : EmptyComponent.INSTANCE;
    }

    public static void endBuild() {
        Preconditions.checkState((boolean)started);
        if (state.fireEvent()) {
            for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
                listener.onHandleTooltip(TOOLTIP, DataAccessor.INSTANCE, PluginConfig.CLIENT);
            }
        }
        TooltipRenderer.narrateObjectName();
        Minecraft client = Minecraft.m_91087_();
        Window window = client.m_91268_();
        float scale = state.getScale();
        int w = 0;
        int h = 0;
        ObjectListIterator iterator = TOOLTIP.iterator();
        while (iterator.hasNext()) {
            Line line = (Line)iterator.next();
            line.calculateDimension();
            int lineW = line.getWidth();
            int lineH = line.getHeight();
            if (lineH <= 0) {
                iterator.remove();
                continue;
            }
            w = maxLineWidth = Math.max(w, lineW);
            h += lineH + 1;
        }
        if (h > 0) {
            --h;
        }
        topOffset = 0;
        if (icon.getHeight() > h) {
            topOffset = Mth.m_184652_((int)(icon.getHeight() - h), (int)2);
        }
        if (icon.getWidth() > 0) {
            w += icon.getWidth() + 3;
        }
        w += 8;
        h = Math.max(h, icon.getHeight()) + 8;
        int windowW = (int)((float)window.m_85445_() / scale);
        int windowH = (int)((float)window.m_85446_() / scale);
        IWailaConfig.Overlay.Position.Align.X anchorX = state.getXAnchor();
        IWailaConfig.Overlay.Position.Align.Y anchorY = state.getYAnchor();
        IWailaConfig.Overlay.Position.Align.X alignX = state.getXAlign();
        IWailaConfig.Overlay.Position.Align.Y alignY = state.getYAlign();
        double x = (double)windowW * anchorX.multiplier - (double)w * alignX.multiplier + (double)state.getX();
        double y = (double)windowH * anchorY.multiplier - (double)h * alignY.multiplier + (double)state.getY();
        if (!state.bossBarsOverlap() && anchorX == IWailaConfig.Overlay.Position.Align.X.CENTER && anchorY == IWailaConfig.Overlay.Position.Align.Y.TOP) {
            y += (double)Math.min(((BossHealthOverlayAccess)client.f_91065_.m_93090_()).wthit_events().size() * 19, window.m_85446_() / 3 + 2);
        }
        RECT.get().setRect(Mth.m_14107_((double)(x + 0.5)), Mth.m_14107_((double)(y + 0.5)), w, h);
        started = false;
    }

    public static void resetState() {
        state = null;
    }

    public static void render(PoseStack matrices, float delta) {
        if (state == null || !state.render()) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        ProfilerFiller profiler = client.m_91307_();
        profiler.m_6180_("Waila Overlay");
        float scale = state.getScale();
        RenderSystem.m_157191_().m_85836_();
        RenderSystem.m_157191_().m_85841_(scale, scale, 1.0f);
        RenderSystem.m_157182_();
        matrices.m_85836_();
        DisplayUtil.enable2DRender();
        Rectangle rect = RENDER_RECT.get();
        rect.setRect(RECT.get());
        if (state.fireEvent()) {
            EventCanceller canceller = EventCanceller.INSTANCE;
            canceller.setCanceled(false);
            for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
                listener.onBeforeTooltipRender(matrices, rect, DataAccessor.INSTANCE, PluginConfig.CLIENT, canceller);
                if (!canceller.isCanceled()) continue;
                matrices.m_85849_();
                RenderSystem.m_69482_();
                RenderSystem.m_157191_().m_85849_();
                RenderSystem.m_157182_();
                profiler.m_7238_();
                return;
            }
        }
        int x = rect.x;
        int y = rect.y;
        int width = rect.width;
        int height = rect.height;
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buf = tesselator.m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = matrices.m_85850_().m_85861_();
        int background = state.getBg();
        int gradStart = state.getGradStart();
        int gradEnd = state.getGradEnd();
        DisplayUtil.fillGradient(matrix, buf, x + 1, y, width - 2, height, background, background);
        DisplayUtil.fillGradient(matrix, buf, x, y + 1, 1, height - 2, background, background);
        DisplayUtil.fillGradient(matrix, buf, x + width - 1, y + 1, 1, height - 2, background, background);
        DisplayUtil.renderRectBorder(matrix, buf, x + 1, y + 1, width - 2, height - 2, gradStart, gradEnd);
        tesselator.m_85914_();
        RenderSystem.m_69493_();
        int textX = x + (icon.getWidth() > 0 ? icon.getWidth() + 7 : 4);
        int textY = y + 4 + topOffset;
        for (Component component : TOOLTIP) {
            Line line = (Line)component;
            line.render(matrices, textX, textY, maxLineWidth, delta);
            textY += line.getHeight() + 1;
        }
        RenderSystem.m_69461_();
        matrices.m_85849_();
        if (state.fireEvent()) {
            for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
                listener.onAfterTooltipRender(matrices, rect, DataAccessor.INSTANCE, PluginConfig.CLIENT);
            }
        }
        IWailaConfig.Overlay.Position.Align.Y iconPos = (IWailaConfig.Overlay.Position.Align.Y)((Object)PluginConfig.CLIENT.getEnum(WailaConstants.CONFIG_ICON_POSITION));
        int iconY = y + 4 + Mth.m_14165_((double)((double)(height - 8 - icon.getHeight()) * iconPos.multiplier));
        if (iconPos == IWailaConfig.Overlay.Position.Align.Y.BOTTOM) {
            ++iconY;
        }
        DisplayUtil.renderComponent(matrices, icon, x + 4, iconY, delta);
        RenderSystem.m_69482_();
        RenderSystem.m_157191_().m_85849_();
        RenderSystem.m_157182_();
        profiler.m_7238_();
    }

    private static void narrateObjectName() {
        ITooltipComponent iTooltipComponent;
        if (!state.render()) {
            return;
        }
        Narrator narrator = NARRATOR.get();
        if (narrator.active() || !state.enableTextToSpeech() || Minecraft.m_91087_().f_91080_ instanceof ChatScreen) {
            return;
        }
        Line objectName = (Line)TOOLTIP.getLine(WailaConstants.OBJECT_NAME_TAG);
        if (objectName != null && (iTooltipComponent = objectName.components.get(0)) instanceof WrappedComponent) {
            WrappedComponent component = (WrappedComponent)iTooltipComponent;
            String narrate = component.component.getString();
            if (!lastNarration.equalsIgnoreCase(narrate)) {
                narrator.clear();
                narrator.say(narrate, true);
                lastNarration = narrate;
            }
        }
    }

    static {
        lastNarration = "";
        icon = EmptyComponent.INSTANCE;
    }

    public static interface State {
        public boolean render();

        public boolean fireEvent();

        public float getScale();

        public IWailaConfig.Overlay.Position.Align.X getXAnchor();

        public IWailaConfig.Overlay.Position.Align.Y getYAnchor();

        public IWailaConfig.Overlay.Position.Align.X getXAlign();

        public IWailaConfig.Overlay.Position.Align.Y getYAlign();

        public int getX();

        public int getY();

        public boolean bossBarsOverlap();

        public int getBg();

        public int getGradStart();

        public int getGradEnd();

        public boolean enableTextToSpeech();

        public int getFontColor();
    }
}

